package com.transsion.search.fragment.result.provider

import android.text.SpannableStringBuilder
import com.blankj.utilcode.util.SizeUtils
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baselib.utils.formatNumberKM
import com.transsion.baseui.image.ImageHelper
import com.transsion.search.R
import com.transsion.search.fragment.result.ResultType
import com.transsion.search.fragment.result.ResultWrapData
import com.transsion.search.getResultSplitSpan

/**
 * Created by gaoxin.liu on 2025/3/19.
 * Description:
 */
class ResultGroupProvider : BaseItemProvider<ResultWrapData>()  {
    override val itemViewType: Int
        get() = ResultType.GROUP.ordinal

    override val layoutId: Int
        get() = R.layout.provider_result_group

    override fun convert(helper: BaseViewHolder, item: ResultWrapData) {
        // 封面
        ImageHelper.loadNet(
            context,
            helper.getView(R.id.search_result_provider_group_cover),
            item.groups?.cover?.url ?: "",
            width = SizeUtils.dp2px(50f),
            thumbnail = item.groups?.cover?.thumbnail?: ""
        )

        //标题
        helper.setText(R.id.search_result_provider_group_title,  item.groups?.name)

        //人数
        val userCountStr = if (item.groups?.userCount != null) item.groups.userCount?.formatNumberKM() else "0"
        val memberStr = context.getString(com.tn.lib.widget.R.string.members, userCountStr)
        helper.setText(R.id.search_result_provider_group_member, memberStr)

        //tag
        val sb = SpannableStringBuilder()
        item.groups?.tags?.forEachIndexed { index, tag ->
            sb.append(tag)
            if (index < (item.groups.tags?.size ?: 0) - 1) {
                sb.append("\uFFFC")
                sb.setSpan(
                    getResultSplitSpan(context), sb.length - 1, sb.length,
                    SpannableStringBuilder.SPAN_EXCLUSIVE_EXCLUSIVE)
            }
        }
        if (sb.isNotEmpty()) {
            helper.setText(R.id.search_result_provider_group_des,  sb)
            helper.setVisible(R.id.search_result_provider_group_des, true)
        } else {
            helper.setGone(R.id.search_result_provider_group_des, true)
        }

        //加圈子，暂不处理圈子
        if (item.groups?.hasJoin != true) {
            helper.setImageResource(R.id.search_result_provider_group_arrow, com.tn.lib.widget.R.mipmap.ic_room_join_def_white)
        } else {
            helper.setImageResource(R.id.search_result_provider_group_arrow, R.drawable.ic_result_arrow)
        }
    }
}