package com.transsion.search.fragment.result.provider

import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baseui.image.ImageHelper
import com.transsion.search.R
import com.transsion.search.fragment.result.ResultType
import com.transsion.search.fragment.result.ResultWrapData

/**
 * Created by gaoxin.liu on 2025/3/19.
 * Description:
 */
class ResultRankProvider : BaseItemProvider<ResultWrapData>()  {
    override val itemViewType: Int
        get() = ResultType.VERTICAL_RANK.ordinal

    override val layoutId: Int
        get() = R.layout.provider_result_rank

    override fun convert(helper: BaseViewHolder, item: ResultWrapData) {
        // 封面
        ImageHelper.loadNet(
            context,
            helper.getView(R.id.search_result_provider_rank_cover),
            item.verticalRank?.cover?.url ?: "",
            thumbnail = item.verticalRank?.cover?.thumbnail?: ""
        )

        //标题
        helper.setText(R.id.search_result_provider_rank_title,  item.verticalRank?.title)

        //人数
        val count = item.verticalRank?.count ?: 0
        val descriptor = if (count > 0) {
            context.getString(com.tn.lib.widget.R.string.sources, count)
        } else {
            item.verticalRank?.description ?: ""
        }
        helper.setText(R.id.search_result_provider_rank_subtitle, descriptor)
    }
}