package com.transsion.search.fragment.result.provider

import android.text.Spannable
import android.text.SpannableStringBuilder
import com.blankj.utilcode.util.SizeUtils
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baseui.image.ImageHelper
import com.transsion.search.R
import com.transsion.search.fragment.result.ResultType
import com.transsion.search.fragment.result.ResultWrapData
import com.transsion.search.getResultSplitSpan

/**
 * Created by gaoxin.liu on 2025/3/19.
 * Description:
 */
class ResultStaffProvider : BaseItemProvider<ResultWrapData>()  {
    override val itemViewType: Int
        get() = ResultType.STAFF.ordinal

    override val layoutId: Int
        get() = R.layout.provider_result_staff

    override fun convert(helper: BaseViewHolder, item: ResultWrapData) {
        // 封面
        ImageHelper.loadNet(
            context,
            helper.getView(R.id.search_result_provider_staff_cover),
            item.staff?.avatarUrl ?: "",
            width = SizeUtils.dp2px(50f),
            placeHolder = com.transsion.moviedetailapi.R.mipmap.movie_staff_default_avatar
        )

        //标题
        helper.setText(R.id.search_result_provider_staff_title,  item.staff?.name)

        //描述
        val sb = SpannableStringBuilder()
        item.staff?.staffTypes?.let {
            it.forEachIndexed { index, staffTypes ->
                sb.append("${staffTypes.name}")
                if (index < it.size - 1) {
                    sb.append(" · ")
                }
            }
        }
        val startIndex = sb.length
        sb.append(" ")
        sb.append("${item.staff?.subjectNum} ${context.getString(R.string.search_works)}")
        //替换预留的分隔符
        sb.setSpan(getResultSplitSpan(context), startIndex, startIndex + 1, Spannable.SPAN_EXCLUSIVE_INCLUSIVE)

        helper.setText(R.id.search_result_provider_staff_brief, sb)

        //简介
        if (item.staff?.description?.isNotEmpty() == true) {
            helper.setVisible(R.id.search_result_provider_staff_des, true)
            helper.setText(R.id.search_result_provider_staff_des, item.staff?.description)

        }  else {
            helper.setGone(R.id.search_result_provider_staff_des, true)
        }
    }
}