package com.transsion.search.fragment.result.provider

import android.text.SpannableStringBuilder
import android.text.style.ForegroundColorSpan
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.blankj.utilcode.util.ColorUtils
import com.blankj.utilcode.util.SizeUtils
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.tn.lib.ext.invisible
import com.tn.lib.ext.visible
import com.transsion.baselib.utils.PlayModeUtil
import com.transsion.baseui.image.ImageHelper
import com.transsion.moviedetailapi.getSubjectIconId
import com.transsion.search.R
import com.transsion.search.fragment.result.ResultType
import com.transsion.search.fragment.result.ResultWrapData
import com.transsion.search.fragment.result.SearchResultFragment
import com.transsion.search.fragment.result.adapter.SearchResultTabAdapter
import com.transsion.search.getImageSpan
import com.transsion.search.getResultSplitSpan
import com.transsion.search.gotoPlayOrDownload
import com.transsion.search.isTablet

/**
 * Created by gaoxin.liu on 2025/3/19.
 * Description:
 */
class ResultSubjectProvider : BaseItemProvider<ResultWrapData>()  {
    override val itemViewType: Int
        get() = ResultType.SUBJECT.ordinal

    override val layoutId: Int
        get() = R.layout.provider_result_subject

    override fun convert(helper: BaseViewHolder, item: ResultWrapData) {
        //音乐改为横版封面
        if (item.subject?.isMusicType() == true) {
            helper.getView<ImageView>(R.id.search_result_provider_subject_cover).apply {
                if (isTablet(resources)) {
                    layoutParams.width = SizeUtils.dp2px(160f)
                    layoutParams.height = SizeUtils.dp2px(90f)
                } else {
                    layoutParams.width = SizeUtils.dp2px(80f)
                    layoutParams.height = SizeUtils.dp2px(45f)
                }
                layoutParams = layoutParams
            }

            helper.getView<TextView>(R.id.search_result_provider_subject_title).apply {
                maxLines = 1
            }
        } else if (isTablet(context.resources)) {
            helper.getView<ImageView>(R.id.search_result_provider_subject_cover).apply {
                layoutParams.width = SizeUtils.dp2px(100f)
                layoutParams.height = SizeUtils.dp2px(140f)
                layoutParams = layoutParams
            }
        }

        // 封面
        ImageHelper.loadNet(
            context,
            helper.getView(R.id.search_result_provider_subject_cover),
            item.subject?.cover?.url ?: "",
            width = SizeUtils.dp2px(80f),
            thumbnail = item.subject?.cover?.thumbnail ?: ""
        )

        //角标
        val coreTextView = helper.getView<TextView>(R.id.search_result_provider_subject_corner)
        if (item.subject?.corner.isNullOrEmpty()) {
            coreTextView.invisible()

        } else {
            coreTextView.text = item.subject?.corner
            coreTextView.visible()
        }

        //标题
        helper.setText(R.id.search_result_provider_subject_title, item.subject?.title)

        //播放按钮
        helper.getView<ImageView>(R.id.search_result_provider_subject_play).apply {
            setOnClickListener {
                gotoPlayOrDownload(item.subject, SearchResultFragment.PAGE_NAME,
                    context, "search_result")

                val adapter = getAdapter()
                if (adapter is SearchResultTabAdapter) {
                    adapter.reportSubjectClick(item.subject, helper.bindingAdapterPosition)
                }
            }

            //短剧默认展示下载按钮，在线模式H5作品显示箭头按钮，下载模式H5作品不显示图标按钮
            if (PlayModeUtil.isStreamMode() && item.subject?.isJumpBrowser() == true) {
                visibility = View.VISIBLE
                setImageResource(R.drawable.ic_result_arrow)
            } else if (!PlayModeUtil.isStreamMode() && item.subject?.isJumpBrowser() == true) {
                visibility = View.INVISIBLE
            } else if (PlayModeUtil.isStreamMode() && item.subject?.isShortTV() == false) {
                visibility = View.VISIBLE
                setImageResource(R.drawable.ic_result_play)
            } else {
                visibility = View.VISIBLE
                setImageResource(R.drawable.ic_result_download)
            }
        }

        /*---------------------------------描述----------------------------------------*/
        val sb = SpannableStringBuilder()

        //1. icon
        val iconSpan = getImageSpan(context, getSubjectIconId(item.subject?.subjectType))
        sb.append("\uFFFC")
        sb.setSpan(iconSpan, 0, 1, SpannableStringBuilder.SPAN_EXCLUSIVE_EXCLUSIVE)
        //2. 分隔符
        sb.append("\uFFFC")
        sb.setSpan(getResultSplitSpan(context), sb.length - 1, sb.length,
            SpannableStringBuilder.SPAN_EXCLUSIVE_EXCLUSIVE)

        //3. 评分icon
        if (item.subject?.imdbRate != null && !item.subject.isMusicType()) {
            val starSpan = getImageSpan(context, R.drawable.ic_search_result_star)
            sb.append("\uFFFC")
            sb.setSpan(starSpan, sb.length - 1, sb.length,
                SpannableStringBuilder.SPAN_EXCLUSIVE_EXCLUSIVE)

            sb.append(" ")
            sb.append(item.subject.imdbRate)
            val foregroundColorSpan = ForegroundColorSpan(ColorUtils.getColor(com.tn.lib.widget.R.color.yellow_60))
            val starLength = item.subject.imdbRate?.length?: 0
            sb.setSpan(foregroundColorSpan, sb.length - starLength, sb.length,
                SpannableStringBuilder.SPAN_EXCLUSIVE_EXCLUSIVE)

            sb.append("\uFFFC")
            sb.setSpan(getResultSplitSpan(context), sb.length - 1, sb.length,
                SpannableStringBuilder.SPAN_EXCLUSIVE_EXCLUSIVE)
        }

        //4. 年份
        if (item.subject?.releaseDate != null) {
            val releaseDate = item.subject.releaseDate ?: ""
            val year =  if (releaseDate.length >= 4) {
                releaseDate.substring(0, 4)
            } else {
                releaseDate
            }

            sb.append(year)
            sb.append("\uFFFC")
            sb.setSpan(getResultSplitSpan(context), sb.length - 1, sb.length,
                SpannableStringBuilder.SPAN_EXCLUSIVE_EXCLUSIVE)
        }

        //5.国家
        if (item.subject?.countryName!= null) {
            sb.append(item.subject.countryName)
            sb.append("\uFFFC")
            sb.setSpan(getResultSplitSpan(context), sb.length - 1, sb.length,
                SpannableStringBuilder.SPAN_EXCLUSIVE_EXCLUSIVE)
        }

        //6. genre
        if (item.subject?.genre!= null) {
            val genreList = item.subject.genre?.split(",")?: listOf()

            //只显示一个
            if (genreList.isNotEmpty()) {
                sb.append(genreList[0])
            }

//            genreList.forEachIndexed { index, genre ->
//                sb.append(genre)
//                if (index < genreList.size - 1) {
//                    sb.append("\uFFFC")
//                    sb.setSpan(getResultSplitSpan(context), sb.length - 1, sb.length,
//                        SpannableStringBuilder.SPAN_EXCLUSIVE_EXCLUSIVE)
//                }
//            }
        }

        helper.getView<TextView>(R.id.search_result_provider_subject_brief).text = sb
        //站外播放
        helper.getView<TextView>(R.id.search_result_provider_subject_website).apply {
            visibility = if (item.subject?.isJumpBrowser() == true) View.VISIBLE else View.GONE
        }
    }
}