package com.transsion.search.fragment.suggest

import android.graphics.Color
import android.text.SpannableStringBuilder
import android.text.Spanned
import android.text.style.ForegroundColorSpan
import com.chad.library.adapter.base.BaseProviderMultiAdapter
import com.transsion.search.bean.SuggestEntity
import com.transsion.search.fragment.suggest.provider.SearchSuggestCopyWritingProvider
import com.transsion.search.fragment.suggest.provider.SearchSuggestListCoverProvider
import com.transsion.search.fragment.suggest.provider.SearchSuggestMovieProvider
import com.transsion.search.fragment.suggest.provider.SearchSuggestStaffProvider

/**
 * @author xinbing.zhang
 * @date :2023/3/23 14:04
 * @description: 搜素联想词 0:联想词 1:作品 2:垂类榜单 3:演员
 */
class SearchSuggestMultiAdapter : BaseProviderMultiAdapter<SuggestEntity>() {

    companion object {
        // title: 对象类型(0:联想词 1:作品 2:垂类榜单 3:演员)
        const val SEARCH_SUGGEST_PROVIDER_STAFF = 3
        const val SEARCH_SUGGEST_PROVIDER_LIST_COVER = 2
        const val SEARCH_SUGGEST_PROVIDER_MOVIE = 1
        const val SEARCH_SUGGEST_PROVIDER_COPY_WRITING = 0

        /**
         * 高亮展示 文案
         */
        fun highlight(mKeyWord: String, original: String?): CharSequence? {
            kotlin.runCatching {
                // 全部转大些用于字符串匹配
                val upKeyWord = mKeyWord.uppercase()
                val upWord = original?.uppercase() ?: ""

                if (upKeyWord.trim { it <= ' ' }.isEmpty()) {
                    return original
                }
                if (!upWord.contains(upKeyWord)) {
                    return original
                }

                // 符合要求处理一下再展示
                val start = upWord.indexOf(upKeyWord)
                val end = start + upKeyWord.length

                val style = SpannableStringBuilder()
                style.append(original)
                if (end != 0 && start != -1) {
                    //设置部分文字颜色
                    val foregroundColorSpan = ForegroundColorSpan(Color.parseColor("#10A84D"))
                    style.setSpan(foregroundColorSpan, start, end, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
                }
                return style
            }
            return ""
        }
    }

    init {
        addItemProvider(SearchSuggestStaffProvider())
        addItemProvider(SearchSuggestListCoverProvider())
        addItemProvider(SearchSuggestMovieProvider())
        addItemProvider(SearchSuggestCopyWritingProvider())
    }


    // =============================================================================================


    /***搜索的关键字 外部传入的 为了高亮关键词*/
    var mKeyWord: String = ""

    fun setKeyWord(keyWord: String) {
        mKeyWord = keyWord
    }


    // =============================================================================================


    override fun getItemType(data: List<SuggestEntity>, position: Int): Int {
        when (data[position].type) {
            SEARCH_SUGGEST_PROVIDER_LIST_COVER -> {
                return SEARCH_SUGGEST_PROVIDER_LIST_COVER
            }

            SEARCH_SUGGEST_PROVIDER_MOVIE -> {
                return SEARCH_SUGGEST_PROVIDER_MOVIE
            }

            SEARCH_SUGGEST_PROVIDER_COPY_WRITING -> {
                return SEARCH_SUGGEST_PROVIDER_COPY_WRITING
            }

            // 新增演员信息展示
            SEARCH_SUGGEST_PROVIDER_STAFF -> {
                return SEARCH_SUGGEST_PROVIDER_STAFF
            }
        }
        return SEARCH_SUGGEST_PROVIDER_COPY_WRITING
    }

}