package com.transsion.search.fragment.suggest.provider

import android.os.Build
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.TextUtils
import android.text.style.DynamicDrawableSpan
import android.text.style.ImageSpan
import androidx.appcompat.widget.AppCompatTextView
import com.blankj.utilcode.util.RegexUtils
import com.blankj.utilcode.util.TimeUtils
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baseui.image.ImageHelper
import com.transsion.moviedetailapi.getSubjectIconId
import com.transsion.search.R
import com.transsion.search.bean.SuggestEntity
import com.transsion.search.fragment.suggest.SearchSuggestMultiAdapter
import java.util.Calendar

/**
 * @author xinbing.zhang
 * @date :2023/3/23 14:06
 * @description:
 */
class SearchSuggestMovieProvider : BaseItemProvider<SuggestEntity>() {

    override val itemViewType: Int
        get() = SearchSuggestMultiAdapter.SEARCH_SUGGEST_PROVIDER_MOVIE

    override val layoutId: Int
        get() = R.layout.fragment_search_suggest_movie_layout

    override fun convert(helper: BaseViewHolder, item: SuggestEntity) {
        // 封面
        ImageHelper.loadNet(
            context, helper.getView(R.id.ivCover), item.subject?.cover?.url ?: ""
        )
        helper.setText(
            R.id.tvTitle, SearchSuggestMultiAdapter.highlight(
                (getAdapter() as? SearchSuggestMultiAdapter)?.mKeyWord ?: "", item.subject?.title
            )
        )
        // 作品的简介
        helper.getViewOrNull<AppCompatTextView>(R.id.tvDes)?.apply {
            val releaseDate = TimeUtils.string2Date(item.subject?.releaseDate, "yyyy-MM-dd")
            val calendar = Calendar.getInstance().apply { time = releaseDate }
            val sb = SpannableStringBuilder()
            sb.append(calendar.get(Calendar.YEAR).toString())
            val strings = RegexUtils.getSplits(item.subject?.genre, ",")
            strings?.forEach {
                sb.append(" · ").append(it)
            }
            if (!TextUtils.isEmpty(item.subject?.countryName)) {
                sb.append(" · ").append(item.subject?.countryName)
            }
            val span = SpannableStringBuilder()
            span.append("  ")
            span.append(sb.toString())
            val subjectImageId = getSubjectIconId(item.subject?.subjectType)
            val imageSpan: ImageSpan = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                ImageSpan(context, subjectImageId, DynamicDrawableSpan.ALIGN_CENTER)
            } else {
                ImageSpan(context, subjectImageId, DynamicDrawableSpan.ALIGN_BASELINE)
            }
            span.setSpan(imageSpan, 0, 1, Spannable.SPAN_EXCLUSIVE_INCLUSIVE)
            text = span
        }
        // 评分
        helper.setText(R.id.tvScore, item.subject?.imdbRate.toString())
        // 季数展示
        val seNum = item.subject?.seNum ?: 0
        helper.setGone(R.id.tvSeasons, seNum <= 1)
        val strSeasons = context.getString(R.string.seasons, seNum.toString())
        helper.setText(R.id.tvSeasons, reorderAndLowercase(strSeasons))

    }

    // 方法来调转顺序并转换为小写
    fun reorderAndLowercase(input: String): String {
        val parts = input.split(" ")
        if (parts.size != 2) {
            return ""
        }
        return "${parts[1]} ${parts[0]}".lowercase()
    }




}