package com.transsion.search.fragment.suggest.provider

import android.os.Build
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.style.DynamicDrawableSpan
import android.text.style.ImageSpan
import androidx.appcompat.widget.AppCompatTextView
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baseui.image.ImageHelper
import com.transsion.search.R
import com.transsion.search.bean.SuggestEntity
import com.transsion.search.fragment.suggest.SearchSuggestMultiAdapter

/**
 * @author xinbing.zhang
 * @date :2023/3/23 14:06
 * @description: 搜索联想词--演员
 */
class SearchSuggestStaffProvider : BaseItemProvider<SuggestEntity>() {

    override val itemViewType: Int
        get() = SearchSuggestMultiAdapter.SEARCH_SUGGEST_PROVIDER_STAFF

    override val layoutId: Int
        get() = R.layout.fragment_search_suggest_staff_layout

    override fun convert(helper: BaseViewHolder, item: SuggestEntity) {
        // 封面
        ImageHelper.loadNet(
            context,
            helper.getView(R.id.ivCover),
            item.staff?.avatarUrl ?: "",
            placeHolder = com.transsion.moviedetailapi.R.mipmap.movie_staff_default_avatar
        )

        helper.setText(R.id.tvTitle, item.staff?.name)

        // 简介
        helper.getViewOrNull<AppCompatTextView>(R.id.tvDes)?.apply {
            val sb = SpannableStringBuilder()
            item.staff?.staffTypes?.let {
                it.forEachIndexed { index, staffTypes ->
                    sb.append("${staffTypes.name}")
                    if (index < it.size - 1) {
                        sb.append(" · ")
                    }
                }
            }
            val span = SpannableStringBuilder()
            span.append("  ")
            span.append(sb.toString())
            val subjectImageId = R.drawable.search_suggest_staff
            val imageSpan: ImageSpan = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                ImageSpan(context, subjectImageId, DynamicDrawableSpan.ALIGN_CENTER)
            } else {
                ImageSpan(context, subjectImageId, DynamicDrawableSpan.ALIGN_BASELINE)
            }
            span.setSpan(imageSpan, 0, 1, Spannable.SPAN_EXCLUSIVE_INCLUSIVE)
            text = span
        }

        // 参演数量
        helper.setText(R.id.tvWorks, "${item.staff?.subjectNum} ${context.getString(R.string.search_works)}")

    }

}