package com.transsion.search.fragment.values

import android.net.Uri
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.ViewModelProvider
import com.alibaba.android.arouter.launcher.ARouter
import com.blankj.utilcode.util.SizeUtils
import com.tn.lib.decoration.GridItemDecoration
import com.tn.lib.logger.Logger
import com.tn.lib.util.expose.RecyclerViewExposeUtil
import com.tn.lib.util.networkinfo.NetworkUtil
import com.tn.lib.view.StateView
import com.tn.lib.view.layoutmanager.NpaGridLayoutManager
import com.tn.lib.widget.toast.TRToast
import com.transsion.baselib.helper.DeeplinkHelper
import com.transsion.baselib.utils.PlayModeUtil
import com.transsion.baseui.fragment.LazyFragment
import com.transsion.baseui.util.FastClickUtils
import com.transsion.moviedetailapi.MovieDetailConstants
import com.transsion.moviedetailapi.MovieDetailPageIdentity
import com.transsion.moviedetailapi.SubjectType
import com.transsion.moviedetailapi.bean.Subject
import com.transsion.publish.api.OperationMenu
import com.transsion.search.R
import com.transsion.search.fragment.values.adapter.SearchResultSubjectAdapter
import com.transsion.search.adapter.SearchWorkAdapter
import com.transsion.search.bean.AccurateSubject
import com.transsion.search.bean.Count
import com.transsion.search.bean.SearchSubject
import com.transsion.search.bean.SearchWorkEntity
import com.transsion.search.constant.Constant
import com.transsion.search.constant.SearchConstants
import com.transsion.search.databinding.FragmentSearchValuesTypeLayoutBinding
import com.transsion.search.fragment.values.SearchValuesFragment.Companion.SEARCH_VALUES_ITEM_ACCURATE_SUBJECT
import com.transsion.search.fragment.values.SearchValuesFragment.Companion.SEARCH_VALUES_ITEM_SUBJECT
import com.transsion.search.viewmodel.SearchViewModel
import com.transsion.search.widget.AccurateSubjectView
import com.transsnet.downloader.DownloadManagerApi
import com.transsnet.flow.event.observeEvent
import com.transsnet.flow.event.postEvent
import com.transsnet.flow.event.sync.event.AddToDownloadEvent

/**
 * @author xinbing.zhang
 * @date :2023/8/23 15:51
 * @description: 区分类型的搜索结果展示
 */
class SearchValuesTypeFragment : LazyFragment<FragmentSearchValuesTypeLayoutBinding>() {


    companion object {

        private const val EXTEND_VALUE_COUNT = "extend_value_count"
        private const val EXTEND_VALUE_ENTITY = "extend_value_entity"
        private const val EXTEND_VALUE_KEYWORD = "extend_value_keyword"
        private const val EXTEND_VALUE_TYPE = "extend_value_type"

        fun newInstance(
            count: Count, keyword: String, mType: Int
        ): SearchValuesTypeFragment {
            val fragment = SearchValuesTypeFragment()
            val bundle = Bundle()
            bundle.apply {
                putSerializable(EXTEND_VALUE_COUNT, count)
                putString(EXTEND_VALUE_KEYWORD, keyword)
                putInt(EXTEND_VALUE_TYPE, mType)
            }
            fragment.arguments = bundle
            return fragment
        }
    }


    // =============================================================================================


    /**
     * 份页搜索
     */
    private var mSearchViewModel: SearchViewModel? = null

    /**
     * 第几页,由于是接着上一次请求而请求的，所以这里的page是从2开始
     */
    private var page: Int = 1

    /**
     * 每一页的数量
     */
    private var perPage: Int = 12

    private var mSubjectAdapter: SearchResultSubjectAdapter? = null

    /**
     * 当前正在搜索的关键字
     */
    private var mKeyWord: String = ""
    private var mType = 1

    private var mCount: Count? = null
    private var mEntity: SearchWorkEntity? = null

    /**
     * 当前tab下所有的数据
     */
    private val subjectList = mutableListOf<SearchSubject>()

    /**
     * 精确匹配作品
     */
    private var accurateSubject: AccurateSubject? = null


    /***loading View 创建出来之后保存内存中*/
    private var loadingView: View? = null

    /**
     * 是否正在加载中
     */
    private var isLoading = false

    /**
     * 曝光组件
     */
    private val exposeUtil = RecyclerViewExposeUtil()


    // =============================================================================================

    override fun receiveArguments() {
        super.receiveArguments()
        arguments?.apply {
            mKeyWord = getString(EXTEND_VALUE_KEYWORD) ?: ""
            mCount = getSerializable(EXTEND_VALUE_COUNT) as? Count
            mType = getInt(EXTEND_VALUE_TYPE)
        }
        mEntity?.let {
            if (mCount?.subjectType == 0) {
                it.items.let { items ->
                    if (items.isNotEmpty()) {
                        items.forEach { item ->
                            subjectList.add(item)
                        }
                    }
                }
            }
            accurateSubject = it.accurateSubject
        }
    }

    fun setSearchWorkEntity(entity: SearchWorkEntity?) {
        mEntity = entity
    }

    override fun getViewBinding(inflater: LayoutInflater): FragmentSearchValuesTypeLayoutBinding =
        FragmentSearchValuesTypeLayoutBinding.inflate(inflater)

    override fun getPageStateLayoutTitle(): String = ""

    override fun getScreenType(): Int {
        return StateView.LOCATION_LABEL_FLOATING_LAYER
    }

    override fun isShowPageStateLayoutTitle(): Boolean = false

    override fun getEmptyView(isShowTitleLayout: Boolean): View {
        return StateView(requireContext()).apply {
            showData(
                dataType = StateView.STATE_TYPE_NO_DATA,
                screenType = getScreenType(),
                isShowTitleLayout = isShowPageStateLayoutTitle(),
                title = getPageStateLayoutTitle(),
                desc = getEmptyDescText(),
            )
        }
    }

    override fun getLoadingView(): View? {
        if (null == loadingView) {
            loadingView = LayoutInflater.from(requireContext())
                .inflate(R.layout.loading_search_values_type_fragment_layout, flStateView, false)
        }
        return loadingView
    }

    override fun initViewData() {
        initSubjectRv()
        observeAddToDownload()
    }

    override fun initViewModel() {
        mSearchViewModel = ViewModelProvider(this)[SearchViewModel::class.java].apply {
            getSearchWorkLiveDataV2().observe(this@SearchValuesTypeFragment.viewLifecycleOwner) { entity ->
                isLoading = false
                showContentView()
                if (null == entity) {
                    mSubjectAdapter?.loadMoreModule?.loadMoreFail()
                } else if (entity.subjectType == mCount?.subjectType) {
                    showLoadMore(entity)
                }
            }
        }
    }

    override fun initListener() {
        //
    }

    override fun retryLoadData() {
        // 这里需要区分一下是加载更多还是重新加载
        if (mSubjectAdapter?.data?.isEmpty() == true) {
            Logger.d(SearchValuesFragment.TAG, "SearchValuesTypeFragment --> retryLoadData() --> 重新连接网络的时候 加载数据")
            lazyLoadData()
        } else {
            loadMore()
        }
    }

    override fun lazyLoadData() {

        // 展示数据
        if (mCount?.subjectType == 0) {
            page = 2
            mSubjectAdapter?.setList(subjectList)
            addHeadView()
        } else {
            Logger.d(SearchValuesFragment.TAG, "SearchValuesTypeFragment --> loadDefaultData() -->  page = $page -- perPage = $perPage -- mKeyWord = ${getKewWord()} -- mCount?.subjectType = ${mCount?.subjectType}")
            if (noNetWork()) {
                return
            }
            showLoadingView()

            // 这里是修复 lazyLoadData() 和 retryLoadData() 同时调用的问题
            if (isLoading) {
                Logger.e(SearchValuesFragment.TAG, "SearchValuesTypeFragment --> loadDefaultData() --> isLoading == true")
                return
            }
            isLoading = true

            mSearchViewModel?.searchWorkV2(
                page, perPage, getKewWord(), mCount?.subjectType ?: 0
            )
        }
    }

    //添加精准匹配作品
    private fun addHeadView() {
        val accurate = mEntity?.accurateSubject
        if (accurate != null) {
            val subjectView = context?.let { AccurateSubjectView(it) }
            if (subjectView != null) {
                mSubjectAdapter?.addHeaderView(subjectView)
                subjectView.setData(accurate)
                subjectView.setOnClickListener {
                    onItemCLick(accurate.subject,0, type = SEARCH_VALUES_ITEM_ACCURATE_SUBJECT)
                }
            }
        }
    }

    override fun onResume() {
        super.onResume()
        if (noNetWork()) {
            return
        }

        // 优化网络监听丢失了 -- 没有数据再次检查一下是否需要加载数据
        if ((mSubjectAdapter?.data?.isEmpty() == true) && (page == 1)) {
            retryLoadData()
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        exposeUtil.destroy()

        mSubjectAdapter?.setList(null)
        isLoading = false
        page = 1
    }


    // =============================================================================================


    private fun noNetWork(): Boolean {
        if (!NetworkUtil.hasCapabilityAsync() && mSubjectAdapter?.data?.isEmpty() == true) {
            showNoNetworkView()
            return true
        }
        return false
    }

    /**
     * 获取搜索的关键字
     */
    private fun getKewWord(): String {
        return (parentFragment as? SearchValuesFragment)?.getKewWord() ?: ""
    }

    /**
     * 更新下载按钮状态
     */
    private fun observeAddToDownload() {
        observeEvent<AddToDownloadEvent> { value ->
            try {
                val index = mSubjectAdapter?.data?.indexOfFirst { it.subjectId == value.subjectId } ?: -1
                if (index >= 0) {
                    mSubjectAdapter?.notifyItemChanged(index + (mSubjectAdapter?.headerLayoutCount ?: 0))
                }
            } catch (e: Exception) {
                Logger.d(SearchValuesFragment.TAG, " callback change data fail")
            }
        }
    }

    /**
     * 初始化 作品列表
     */
    private fun initSubjectRv() {
        mViewBinding?.rvSubject?.apply {
            itemAnimator = null
            layoutManager = NpaGridLayoutManager(context,3)
            mSubjectAdapter = SearchResultSubjectAdapter(context).apply {

                // 加载更多监听器
                loadMoreModule.setOnLoadMoreListener {
                    loadMore()
                }

                setOnItemClickListener { _, _, position ->
                    val subject = mSubjectAdapter?.data?.get(position)
                    onItemCLick(subject,position)
                }

                addChildClickViewIds(R.id.llDownload)
                setOnItemChildClickListener { adapter, view, position ->
                    if (view.id == R.id.llDownload) {
                        if (FastClickUtils.isFastClick(view.id, 2000)) {
                            return@setOnItemChildClickListener
                        }
                        getDownloadList(adapter.data[position] as? Subject)
                    }
                }

            }
            adapter = mSubjectAdapter

            // 添加分割线 -- 只有第一个需要处理 top 8dp
            addItemDecoration(
                GridItemDecoration(
                    SizeUtils.dp2px(4f),
                    SizeUtils.dp2px(8 / 2f),
                    SizeUtils.dp2px(16f),
                    SizeUtils.dp2px(16f)
                )
            )
            exposeUtil.setRecyclerItemExposeListener(this,
                object : RecyclerViewExposeUtil.OnItemExposeListener {
                    override fun onItemViewVisible(visible: Boolean, position: Int) {
                        if (visible) {
                            val get = mSubjectAdapter?.data?.getOrNull(position)
                            SearchValuesFragment.reportShow(
                                group_id = "",
                                subject_id = get?.subjectId,
                                staffId = "",
                                ops = get?.ops,
                                position,
                                SEARCH_VALUES_ITEM_SUBJECT
                            )
                        }
                    }

                    override fun getTotalSize(): Int {
                        return mSubjectAdapter?.data?.size ?: 0
                    }

                })
        }
    }

    /**
     * 整个Item点击了
     */
    private fun onItemCLick(subject: SearchSubject?, position: Int,type:Int = SEARCH_VALUES_ITEM_SUBJECT) {
        subject?.let {
            // 点击埋点
            if (position >= 0) {
                SearchValuesFragment.reportClick(
                    "",
                    it.subjectId,
                    "",
                    it.ops,
                    position,
                    type,
                    SearchValuesFragment.trid
                )
            }
            if (it.viewType == SearchWorkAdapter.SEARCH_ASSOCIATION_TYPE) {
                it.verticalRank?.deeplink?.let { deeplink ->
                    val uri = DeeplinkHelper.toRouteUri(Uri.parse(deeplink))
                    if (uri != null) {
                        ARouter.getInstance().build(uri).navigation()
                    }
                }
                return@let
            }

            if (mType == SearchConstants.SEARCH_MOVIE) {
                if (it.subjectType == SubjectType.SHORT_TV.value) {
                    DownloadManagerApi.INSTANCE.downloadShortTV(
                        activity = context as FragmentActivity,
                        page_from = logViewConfig?.pageName,
                        groupId = "",
                        opss = it.ops,
                        moduleName = "download_subject",
                        scroll2Download = false,
                        subject = it
                    )
                } else {
                    ARouter.getInstance().build(MovieDetailPageIdentity.MOVIE_DETAIL)
                        .withInt(MovieDetailConstants.SUBJECT_TYPE, it.subjectType ?: SubjectType.MOVIE.value)
                        .withString(MovieDetailConstants.SUBJECT_ID, it.subjectId)
                        .withString(MovieDetailConstants.OPS, it.ops).navigation()
                }
                return@let
            }

            val opertaion = OperationMenu()
            opertaion.item_type = Constant.ITEM_WORKS
            opertaion.item_operation = Constant.OPERATION_ADD
            opertaion.subject = it
            postEvent(opertaion)
            activity?.finish()
        }
    }

    /**
     * 上拉加载更多
     */
    private fun loadMore() {
        if (NetworkUtil.hasCapabilityAsync()) {
            mSearchViewModel?.searchWorkV2(
                page, perPage, getKewWord(), mCount?.subjectType ?: 0
            )
        } else {
            TRToast.show(com.tn.lib.widget.R.string.no_network_toast)
            mViewBinding?.rvSubject?.postDelayed({
                mSubjectAdapter?.loadMoreModule?.loadMoreFail()
            }, 300)
        }
    }

    /**
     * 搜索到作品之后直接下载 -------------------------------------------------------------------------
     */
    private fun getDownloadList(subjectEntity: Subject?) {
        if (subjectEntity?.subjectType == SubjectType.SHORT_TV.value) {
            //短剧下载按钮点击-打开下载弹窗
            DownloadManagerApi.INSTANCE.downloadShortTV(
                activity = context as FragmentActivity,
                page_from = logViewConfig?.pageName,
                groupId = "",
                opss = subjectEntity.ops,
                moduleName = "download_subject",
                scroll2Download = true,
                subject = subjectEntity
            )
            return
        }
        if (PlayModeUtil.isStreamMode()) {
            goPlayStreamSubject(subjectEntity)
            return
        }
        //判断是播放还是下载
        var resourceId = ""
        var isSeries = false
        subjectEntity?.resourceDetectors?.let {
            if (it.isNotEmpty()) {
                resourceId = it[0].resourceId ?: ""
                isSeries = it[0].type == 1 || it[0].isMultiResolution()
            }
        }
        val playAvailable = DownloadManagerApi.INSTANCE.playAvailable(
            subjectId = subjectEntity?.subjectId, resourceId = resourceId, isSeries
        )
        if (playAvailable) {
            subjectEntity?.subjectId?.let {
                context?.let { itt ->
                    DownloadManagerApi.INSTANCE.playNow(it, itt, pageFrom = logViewConfig?.pageName)
                }
            }
            return
        }

        // 如果是单集，那就直接下载
        kotlin.runCatching {
            var source = ""
            subjectEntity?.resourceDetectors?.let {
                if (it.isNotEmpty()) {
                    source = it[0].resourceLink ?: ""
                }
            }
            DownloadManagerApi.INSTANCE.addDownloadListWithDialog(
                activity = (context as FragmentActivity),
                subject = subjectEntity,
                page_from = logViewConfig?.pageName,
                groupId = "",
                opss = subjectEntity?.ops,
                resource = source,
                moduleName = "download_subject"
            )
        }
    }
    private fun goPlayStreamSubject(item: Subject?) {
        if (item == null) return
        ARouter.getInstance().build("/playvideo/detail")
            .withInt(MovieDetailConstants.SUBJECT_TYPE, item.subjectType ?: SubjectType.MOVIE.value)
            .withString(MovieDetailConstants.SUBJECT_ID, item.subjectId)
            .withString(MovieDetailConstants.OPS, item.ops).navigation()
    }

    /**
     * 处理加载更多的数据
     */
    private fun showLoadMore(entity: SearchWorkEntity?) {
        mSubjectAdapter?.loadMoreModule?.loadMoreComplete()
        page = entity?.pager?.nextPage ?: 1
        perPage = entity?.pager?.perPage ?: 10

        val dataList = entity?.items
        val hasMore = entity?.pager?.hasMore ?: false

        if (dataList.isNullOrEmpty() && mSubjectAdapter?.data?.isEmpty() == true) {
            showEmptyView()
        }

        if (!dataList.isNullOrEmpty()) {
            // 搜索结果的数据
            mSubjectAdapter?.addData(dataList)
        } else {
            mSubjectAdapter?.loadMoreModule?.loadMoreEnd(false)
        }

        if (!hasMore) {
            mSubjectAdapter?.loadMoreModule?.loadMoreEnd(false)
        }

        if (null == entity) {
            mSubjectAdapter?.loadMoreModule?.loadMoreFail()
        }
    }
}