package com.transsion.search.fragment.values.adapter

import com.chad.library.adapter.base.BaseProviderMultiAdapter
import com.transsion.search.bean.SearchValuesRelatedCollectionEntity
import com.transsion.search.fragment.values.SearchValuesFragment.Companion.SEARCH_VALUES_RANK_TYPE_STAFF
import com.transsion.search.fragment.values.SearchValuesFragment.Companion.SEARCH_VALUES_RANK_TYPE_TITLE
import com.transsion.search.fragment.values.SearchValuesFragment.Companion.SEARCH_VALUES_RANK_TYPE_VERTICAL_RANK

/**
 * @author xinbing.zhang
 * @date :2023/9/12 20:19
 * @description: 搜索结果页面榜单列表适配器
 */
class SearchValuesRelatedCollectionAdapter :
    BaseProviderMultiAdapter<SearchValuesRelatedCollectionEntity>() {

    init {
        addItemProvider(SearchValuesRelatedCollectionTitleProvider())
        addItemProvider(SearchValuesRelatedCollectionVerticalRankProvider())
        addItemProvider(SearchValuesRelatedCollectionStaffProvider())
    }

    override fun getItemType(data: List<SearchValuesRelatedCollectionEntity>, position: Int): Int {
        return when (data[position].type) {
            SEARCH_VALUES_RANK_TYPE_TITLE -> {
                SEARCH_VALUES_RANK_TYPE_TITLE
            }

            SEARCH_VALUES_RANK_TYPE_VERTICAL_RANK -> {
                SEARCH_VALUES_RANK_TYPE_VERTICAL_RANK
            }

            SEARCH_VALUES_RANK_TYPE_STAFF -> {
                SEARCH_VALUES_RANK_TYPE_STAFF
            }

            else -> {
                SEARCH_VALUES_RANK_TYPE_TITLE
            }
        }
    }


    // =============================================================================================


    private var mKeyWord = ""

    /**
     * 搜索关键字
     */
    fun setKeyWord(keyword: String) {
        mKeyWord = keyword
    }

    fun getKeyWord(): String {
        return mKeyWord
    }

}