package com.transsion.search.fragment.values.adapter

import com.blankj.utilcode.util.SizeUtils
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.google.android.material.imageview.ShapeableImageView
import com.transsion.baseui.image.ImageHelper
import com.transsion.search.R
import com.transsion.search.fragment.suggest.SearchSuggestMultiAdapter
import com.transsion.search.bean.SearchValuesRelatedCollectionEntity
import com.transsion.search.fragment.values.SearchValuesFragment
import com.transsion.search.fragment.values.SearchValuesFragment.Companion.SEARCH_VALUES_RANK_TYPE_VERTICAL_RANK

/**
 * @author xinbing.zhang
 * @date :2023/9/12 20:42
 * @description:
 */
class SearchValuesRelatedCollectionVerticalRankProvider :
    BaseItemProvider<SearchValuesRelatedCollectionEntity>() {

    private val designW = SizeUtils.dp2px(72f)
    private val designH = SizeUtils.dp2px(96f)


    override val itemViewType: Int
        get() = SEARCH_VALUES_RANK_TYPE_VERTICAL_RANK

    override val layoutId: Int
        get() = R.layout.item_search_values_vertical_rank_layout

    override fun convert(helper: BaseViewHolder, item: SearchValuesRelatedCollectionEntity) {
        // 显示文案
        helper.setText(
            R.id.tvTitle, SearchSuggestMultiAdapter.highlight(getKeyWord(), item.verticalRank?.title)
        )
        // 描述
        helper.setText(R.id.tvSubTitle, item.verticalRank?.description)
        // 图片展示
        helper.getView<ShapeableImageView>(R.id.ivCover).let { cover ->
            val url =
                ImageHelper.getReSizeUrl(item.verticalRank?.cover?.url ?: "", designW, designH)
            context.let { context ->
                ImageHelper.loadNet(context, cover, url)
            }
        }

        // 曝光
        SearchValuesFragment.reportShow(
            group_id = "",
            subject_id = "",
            staffId = item.staff?.staffId,
            ops = "",
            position = helper.bindingAdapterPosition,
            SEARCH_VALUES_RANK_TYPE_VERTICAL_RANK
        )
    }

    private fun getKeyWord():String{
        return (getAdapter() as? SearchValuesRelatedCollectionAdapter)?.getKeyWord()?:""
    }
}