package com.transsion.search.net

import com.tn.lib.net.bean.BaseDto
import com.tn.lib.net.cons.NetConst
import com.tn.lib.net.env.Host
import com.transsion.publish.model.PostEntity
import com.transsion.search.bean.*
import io.reactivex.rxjava3.core.Observable
import okhttp3.RequestBody
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Query

interface SearchApi {
    /**
     * 搜索作品
     */
    @POST("/wefeed-mobile-bff/subject-api/search")
    suspend fun searchSubject(
        @Query(NetConst.HOST) host: String, @Body request: RequestBody
    ): BaseDto<SearchWorkEntity>

    @POST("/wefeed-mobile-bff/subject-api/search/v2")
    suspend fun searchSubjectV2(
        @Query(NetConst.HOST) host: String, @Body request: RequestBody
    ): BaseDto<SearchResultEntity>

    /**
     * 搜索群组
     */
    @GET("/wefeed-mobile-bff/group/list/search")
    fun searchGroup(
        @Query(NetConst.HOST) host: String,
        @Query("page") page: Int,
        @Query("keyword") keyword: String
    ): Observable<BaseDto<SearchGroupEntity>>

    /**
     * 群组推荐
     */
    @GET("/wefeed-mobile-bff/group/list/select")
    fun getGroupRecommend(
        @Query(NetConst.HOST) host: String,
        @Query("page") page: String,
        @Query("count") count: Int,
    ): Observable<BaseDto<SearchGroupEntity>>

    /**
     * 加入圈子
     */
    @POST("/wefeed-mobile-bff/group/join")
    fun joinGroup(
        @Query(NetConst.HOST) host: String, @Body request: RequestBody
    ): Observable<BaseDto<JoinGroupEntity>>


    /**
     * 获取热榜
     * @param everyOneSearch  是否返回大家都在搜 0:否 1:是
     */
    @GET("/wefeed-mobile-bff/subject-api/search-rank/v2")
    fun getHotSubject(@Query("everyoneSearch") everyOneSearch: Int, @Query("room") room: Int = 1): Observable<BaseDto<HotSubjectEntity>>

    /***搜索关键词推荐*/
    @GET("/wefeed-mobile-bff/subject-api/search-suggest")
    fun getSearchSuggest(
        @Query("keyword") keyword: String, // 关键字
        @Query("perPage") perPage: Int = 20, // 条数(默认20)
        @Query("resultMode") resultMode: Int = 2 // 返回结果模式(0:只联想词 1:联想词+作品+垂类榜单 2:联想词+作品+垂类榜单+演员)
    ): Observable<BaseDto<SearchSuggestEntity>>



    @POST("/wefeed-mobile-bff/feedback/commit")
    suspend fun feedback(
        @Query(NetConst.HOST) host: String,
        @Body request: RequestBody
    ): BaseDto<FeedbackEntity?>

    @POST("/wefeed-mobile-bff/search-anaylze/seek")
    fun postRequestResource(
        @Query(NetConst.HOST) host: String = Host.getHost(),
        @Body requestBody: RequestBody
    ):Observable<BaseDto<PostEntity?>>
}