package com.transsion.search.net

import com.google.gson.JsonObject
import com.tn.lib.net.bean.BaseDto
import com.tn.lib.net.env.Host
import com.tn.lib.net.manager.NetServiceGenerator
import com.transsion.search.bean.FeedbackEntity
import com.transsion.search.bean.HotSubjectEntity
import com.transsion.search.bean.JoinGroupEntity
import com.transsion.search.bean.SearchGroupEntity
import com.transsion.search.bean.SearchSuggestEntity
import com.transsion.search.bean.SearchWorkEntity
import io.reactivex.rxjava3.core.Observable
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.RequestBody.Companion.toRequestBody

class SearchModel {

    companion object {
        const val GET_EVERYONE_SEARCH = 1
    }

    suspend fun searchSubject(entity: RequestSearchEntity): BaseDto<SearchWorkEntity> {
        //val request = getRequestBody(GsonUtils.toJson(entity))
        var json = JsonObject()
        json.addProperty("page", entity.page)
        json.addProperty("perPage", entity.perPage)
        json.addProperty("keyword", entity.keyword)
        json.addProperty("subjectType", entity.subjectType)
        json.addProperty("resultMode",1)
        var body = json.toString().toRequestBody("application/json".toMediaTypeOrNull())
        return service.searchSubject(getHost(), body)
    }

    fun searchGroup(entity: RequestSearchEntity): Observable<BaseDto<SearchGroupEntity>> {
        var json = JsonObject()
        json.addProperty("page", entity.page)
        json.addProperty("keyword", entity.keyword)
        var body = json.toString().toRequestBody("application/json".toMediaTypeOrNull())
        return service.searchGroup(getHost(), entity.page, entity.keyword)
    }

    fun joinGroup(entity: RequestJoinGroupEntity): Observable<BaseDto<JoinGroupEntity>> {
        var json = JsonObject()
        json.addProperty("groupId", entity.groupId)
        var body = json.toString().toRequestBody("application/json".toMediaTypeOrNull())
        return service.joinGroup(getHost(), body)
    }

    fun getGroups(entity: RequestGroupEntity): Observable<BaseDto<SearchGroupEntity>> {
        //var json = JsonObject()
        //json.addProperty("page", entity.page)
        //json.addProperty("count", 10)
        //var body = json.toString().toRequestBody("application/json".toMediaTypeOrNull())
        return service.getGroupRecommend(getHost(), entity.page, 10)
    }

    fun getHotSubject(): Observable<BaseDto<HotSubjectEntity>> {
        return service.getHotSubject(GET_EVERYONE_SEARCH)
    }

    /***搜索推荐API*/
    fun getSearchSuggest(keyword: String): Observable<BaseDto<SearchSuggestEntity>> {
        return service.getSearchSuggest(keyword)
    }

    private val service: SearchApi by lazy {
        NetServiceGenerator.instance.getService(SearchApi::class.java)
    }


    suspend fun feedback(content: String, uid: String? = null, email: String? = null): BaseDto<FeedbackEntity?> {
        var json = JsonObject()
        json.addProperty("content", content)
        json.addProperty("uid", uid)
        email?.let {
            json.addProperty("email", it)
        }
        var body = json.toString().toRequestBody("application/json".toMediaTypeOrNull())
        return service.feedback(getHost(), body)
    }



    private fun getHost(): String {
        return Host.getHost() //"https://vskit2.mylichking.com"
    }
}