package com.transsion.search.speech

import java.util.Random
import java.util.concurrent.ThreadLocalRandom

/**
 * @author: zhangxinbing
 * @date : 2024/8/29 11:14
 * @description: 随机数生成工具类
 */
object RandomUtils {

    /**
     * 随机字符串 来源密钥
     */
    private const val SOURCE_KEY: String =
        "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"

    /**
     * Create a random number for device name suffix. Not use now
     */
    fun getRandomId(): Int {
        val max = 0xffff
        val min = 0x1111
        val random = ThreadLocalRandom.current()
        return random.nextInt(max) % (max - min + 1) + min
    }

    /**
     * 获取随机字符串
     *
     * @param length : 目标随机字符串长度
     */
    fun getRandomString(length: Int): String {
        val buffer = StringBuffer(SOURCE_KEY)
        val sb = StringBuffer()
        val random = ThreadLocalRandom.current()
        val range = buffer.length
        for (i in 0 until length) {
            sb.append(buffer[random.nextInt(range)])
        }
        return sb.toString()
    }

    /**
     * 获取随机 4 个 int num
     */
    fun getRandom4IntNum(): Int {
        val max = 9999
        val min = 1000
        val random = Random()
        return (random.nextInt(max - min) + min + 1)
    }

    /**
     * 生成的随机数
     */
    fun getRandom(len: Int): String {
        var i: Int
        var count = 0
        // 密码字典
        val str = charArrayOf(
            '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'
        )
        val stringBuffer = StringBuffer()
        val r = Random()
        while (count < len) {
            //生成 0 ~ 密码字典-1之间的随机数
            i = r.nextInt(str.size)
            stringBuffer.append(str[i])
            count++
        }
        return stringBuffer.toString()
    }

}