package com.transsion.search.speech

import com.blankj.utilcode.util.Utils
import com.transsion.search.R

/**
 * @author: zhangxinbing
 * @date : 2024/10/12 16:16
 * @description: 语音识别 错误代码
 */
object SRErrorUtil {

    /** Network operation timed out.  网络操作超时 */
    private const val ERROR_NETWORK_TIMEOUT: Int = 1

    /** Other network related errors.  其他网络相关错误 */
    private const val ERROR_NETWORK: Int = 2

    /** Audio recording error.  录音错误 */
    private const val ERROR_AUDIO: Int = 3

    /** Server sends error status.  服务器发送错误状态 */
    private const val ERROR_SERVER: Int = 4

    /** Other client side errors.  其他客户端错误 */
    private const val ERROR_CLIENT: Int = 5

    /** No speech input  无语音输入 */
    private const val ERROR_SPEECH_TIMEOUT: Int = 6

    /** No recognition result matched.  没有匹配到的识别结果 */
    private const val ERROR_NO_MATCH: Int = 7

    /** RecognitionService busy.  识别服务正忙 */
    private const val ERROR_RECOGNIZER_BUSY: Int = 8

    /** Insufficient permissions  权限不足 */
    private const val ERROR_INSUFFICIENT_PERMISSIONS: Int = 9

    /** Too many requests from the same client.  来自同一客户端的请求过多 */
    private const val ERROR_TOO_MANY_REQUESTS: Int = 10

    /** Server has been disconnected, e.g. because the app has crashed.  服务器已断开连接，例如因为应用程序崩溃了 */
    private const val ERROR_SERVER_DISCONNECTED: Int = 11

    /** Requested language is not available to be used with the current recognizer.  当前识别器无法使用请求的语言 */
    private const val ERROR_LANGUAGE_NOT_SUPPORTED: Int = 12

    /** Requested language is supported, but not available currently (e.g. not downloaded yet).  支持请求的语言，但当前不可用（例如尚未下载） */
    private const val ERROR_LANGUAGE_UNAVAILABLE: Int = 13

    /** The service does not allow to check for support.  该服务不允许检查支持 */
    private const val ERROR_CANNOT_CHECK_SUPPORT: Int = 14

    /** The service does not support listening to model downloads events.  该服务不支持监听模型下载事件 */
    private const val ERROR_CANNOT_LISTEN_TO_DOWNLOAD_EVENTS: Int = 15

    /**
     * The recognizer was cancelled.  识别器已取消
     */
    const val ERROR_CANCEL: Int = 16


    // =============================================================================================


    /**
     * 获取错误文案
     *
     * 1. Didn’t hear that. Try speaking again.
     * 2. You’re offline. Please connect and try again.
     * 3. Something went wrong. Please try again.
     */
    fun getErrorMsg(errorCode: Int): String {
        return when (errorCode) {
            ERROR_NETWORK_TIMEOUT, ERROR_NETWORK -> {
                Utils.getApp().resources.getString(R.string.search_sr_try_again)
            }

            ERROR_SPEECH_TIMEOUT, ERROR_NO_MATCH -> {
                Utils.getApp().resources.getString(R.string.search_sr_try_speaking_again)
            }

            ERROR_CANCEL -> {
                Utils.getApp().resources.getString(R.string.search_sr_cancelled)
            }

            else -> {
                Utils.getApp().resources.getString(R.string.search_sr_wrong_try_again)
            }
        }
    }

}