package com.transsion.search.speech

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.view.View.OnClickListener
import androidx.appcompat.app.AppCompatActivity
import androidx.appcompat.widget.AppCompatImageView
import com.blankj.utilcode.util.Utils
import com.permissionx.guolindev.PermissionX
import com.permissionx.guolindev.dialog.DialogInfo
import com.transsion.baseui.util.FastClickUtils
import com.transsion.baseui.util.normalClick
import com.transsion.search.R

/**
 * @author: zhangxinbing
 * @date : 2024/10/11 17:23
 * @description: 语音识别自定义View
 */
class SpeechRecognizerView @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null
) : AppCompatImageView(context, attrs), OnClickListener {

    /**
     * 语音识别到的结果通过这个返回
     */
    private var mCallback: ((result: String?) -> Unit?)? = null

    private fun getClassTag(): String = javaClass.simpleName

    init {
        setOnClickListener(this)
        setBackgroundResource(R.drawable.sr_icon_microphone)
    }


    // =============================================================================================


    override fun onClick(v: View?) {
        normalClick(time = 1000) {
            SrReport.clickMicBtn()

            (context as? AppCompatActivity)?.let {
                PermissionX.init(it).permissions(android.Manifest.permission.RECORD_AUDIO)
                    .explainReasonBeforeRequest()
                    .onExplainRequestReason { scope, deniedList, beforeRequest, shouldGotoSetting ->
                        if (beforeRequest.not()) { //请求权限之后，无需弹窗
                            return@onExplainRequestReason
                        }
                        if (shouldGotoSetting) {
                            val dialogInfo = DialogInfo(
                                subtitle = resources.getString(R.string.search_sr_permission_tip),
                                buttonText = resources.getString(R.string.search_sr_permission_setting),
                                iconResId = R.mipmap.sr_icon_active,
                                iconBgColorResId = com.tn.lib.widget.R.color.white_20,
                            )
                            scope.showForwardToSettingsDialog(deniedList, dialogInfo)
                            return@onExplainRequestReason
                        }
                        scope.requestAgain(deniedList)
                    }.request { allGranted, grantedList, deniedList ->
                        SRLogger.logD("${getClassTag()} --> allGranted = $allGranted")
                        if (allGranted) {
                            SpeechRecognizerDialog().setCallback(mCallback).show(
                                it.supportFragmentManager, "SpeechRecognizerDialog"
                            )
                        }
                    }
            } ?: run {
                SRLogger.logD("${getClassTag()} --> context as? AppCompatActivity == null")
            }
        }
    }


    // =============================================================================================


    /**
     * 将结果导出
     */
    fun setCallback(callback: ((result: String?) -> Unit?)? = null) {
        mCallback = callback
    }
}