package com.transsion.search.speech

import com.blankj.utilcode.util.DeviceUtils
import com.transsion.baselib.helper.DataHelper

/**
 * @author: zhangxinbing
 * @date : 2024/10/24 15:38
 * @description:语音识别埋点
 */
object SrReport {

    private var randomString: String? = null

    /**
     * 麦克风按钮点击
     */
    fun clickMicBtn() {
        DataHelper.reportClickEvent("sr_mic_btn", emptyMap())
    }

    /**
     * 弹窗取消按钮
     */
    fun clickCancelBtn() {
        DataHelper.reportClickEvent("sr_dialog_cancel_btn", emptyMap())
    }

    /**
     * 开始录音
     */
    fun srStart() {
        val map = mutableMapOf<String, String>()
        map["action"] = "trigger"
        randomString = RandomUtils.getRandomString(10)
        map["trigger_id"] = randomString.toString()
        DataHelper.reportBrowseEvent("sr_dialog_sr", map)
    }

    /**
     * 识别成功
     */
    fun srSuccess() {
        val map = mutableMapOf<String, String>()
        map["action"] = "success"
        map["trigger_id"] = randomString.toString()
        DataHelper.reportBrowseEvent("sr_dialog_sr", map)
        randomString = null
    }

    /**
     * 识别失败
     */
    fun srFail(msg: String, code: Int) {
        val map = mutableMapOf<String, String>()
        map["action"] = "fail"
        map["msg"] = msg
        map["code"] = code.toString()
        map["trigger_id"] = randomString.toString()
        DataHelper.reportBrowseEvent("sr_dialog_sr", map)
        randomString = null
    }

    /**
     * 使用第二种策略
     */
    fun useSecondStrategy() {
        val map = mutableMapOf<String, String>()
        map["action"] = "strategy"
        map["value"] = "two"
        map["model"] = DeviceUtils.getModel()
        DataHelper.reportClickEvent("sr_dialog_sr", emptyMap())
    }

}