package com.transsion.search.viewmodel

import android.util.Log
import androidx.core.text.isDigitsOnly
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.blankj.utilcode.util.Utils
import com.transsion.baselib.db.AppDatabase
import com.transsion.baselib.db.video.VideoDetailPlayBean
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

/**
 * @author: zhiwei.chen
 * @date: 2025/2/28
 * @description: 搜索作品 ViewModel
 */
class SearchWorkViewModel : ViewModel() {
    var hasMore = true
        private set
    val historyData = MutableLiveData<MutableList<VideoDetailPlayBean>>()
    private val historyList: MutableList<VideoDetailPlayBean> = mutableListOf()
    private val videoDao by lazy {
        AppDatabase.getInstance(Utils.getApp()).videoDetailPlayDao()
    }

    // 假设每页加载10条数据
    var offset: Int = 0 // 初始偏移量为0
    private var limit: Int = 50

    /**
     * 获取视频播放记录-- 分页加载
     */
    fun getVideoHistoryList(isRefreshAll: Boolean = false) {
        viewModelScope.launch(Dispatchers.IO) {
            // 判断是否是刷新
            if (isRefreshAll) {
                offset = 0
                hasMore = true
                historyList.clear()
            }
            // 分页加载
            var playHistory = videoDao.getHistoryDataOffset(offset, limit)
            // 校验是否还有下一页
            if (playHistory.isNullOrEmpty() || playHistory.size < limit) {
                hasMore = false
            }
            // 过滤异常id（非官方视频等）
            playHistory = playHistory?.filter { it.id.isDigitsOnly() }
            Log.e("SearchWork", "获取视频播放记录 数量： ${playHistory?.size}，hasMore:$hasMore")
            playHistory ?: return@launch
            historyList.addAll(playHistory)
            // 加载更多数据时，更新偏移量
            offset += playHistory.size
            historyData.postValue(historyList.toMutableList())
        }
    }
}