package com.transsion.search.widget

import android.content.Context
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.google.android.flexbox.FlexLine
import com.google.android.flexbox.FlexboxLayoutManager

/**
 * Created by gaoxin.liu on 2024/5/17.
 * Description: 支持行数限制
 */
class LinesFlexBoxLayoutManager(context: Context) : FlexboxLayoutManager(context) {
    private var mMaxLines = 0
    private var mOverMaxLineListener: (() -> Unit)? = null
    private var actualLineCount = mutableListOf<Pair<Int, Int>>()

    fun setFlowLine(maxLine: Int) {
        mMaxLines = maxLine
        requestLayout()
    }

    fun setOnOverMaxLineListener(listener: () -> Unit) {
        mOverMaxLineListener = listener
    }

    fun getActualLineCount(): Int {
        return if (actualLineCount.size == 0) super.getFlexLinesInternal().size else actualLineCount.size
    }

    fun resetLineData(){
        actualLineCount.clear()
    }

    fun getSpecialLineIndex(lineIndex: Int): Int {
        return kotlin.runCatching { actualLineCount[lineIndex].second }.getOrDefault(-1)
    }

    fun getRenderedItemCount(): Int {
        var totalCount = 0

        actualLineCount.forEachIndexed { index, flexLine ->
            if (index < mMaxLines) {
                totalCount = flexLine.second
            }
        }

        return totalCount
    }

    override fun getFlexLinesInternal(): MutableList<FlexLine> {
        val flexLines = super.getFlexLinesInternal()

        var curIndex = 0
        if (flexLines.size > actualLineCount.size) {
            actualLineCount.clear()

            flexLines.forEach { flexLine ->
                actualLineCount.add(Pair(curIndex + 1, curIndex + flexLine.itemCount))
                curIndex += flexLine.itemCount
            }
        }

        if (mMaxLines == 0) {
            return flexLines
        }
        if (flexLines.size > mMaxLines) {
            flexLines.subList(mMaxLines, flexLines.size).clear()
            mOverMaxLineListener?.invoke()
        }
        return flexLines
    }

    override fun onLayoutChildren(recycler: RecyclerView.Recycler?, state: RecyclerView.State?) {
        try {
            super.onLayoutChildren(recycler, state)
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    override fun attachView(child: View) {
        if (child.parent != null) {
            (child.parent as ViewGroup).removeView(child)
        }
        super.attachView(child)
    }
}