package com.transsion.search.widget

import com.transsion.baselib.helper.DataHelper
import com.transsion.baselib.report.Report
import com.transsion.moviedetailapi.bean.Group
import com.transsion.moviedetailapi.bean.Staff
import com.transsion.moviedetailapi.bean.Subject
import com.transsion.search.bean.GroupInfo
import com.transsion.search.bean.HotSubject
import com.transsion.search.bean.SuggestEntity
import com.transsion.search.bean.VerticalRank
import com.transsion.search.fragment.BaseSearchMainFragment.Companion.sSearchId
import com.transsion.search.fragment.hot.SearchHotFragment
import com.transsion.search.fragment.result.SearchResultFragment
import com.transsion.search.fragment.suggest.SearchSuggestFragment.Companion.PAGE_NAME_SEARCH_SUGGEST_FRAGMENT

/**
 * Created by gaoxin.liu on 2025/3/26.
 * Description: 埋点工具类
 */
class SearchReportHelper {
    companion object {
        const val SEARCH_FROM_INPUT = "input"
        const val SEARCH_FROM_HISTORY = "history"
        const val SEARCH_FROM_HINT = "hint"
        const val SEARCH_FROM_DEEPLINK = "deeplink"
        const val SEARCH_FROM_VOICE = "voice"
        const val SEARCH_FROM_SUGGEST = "suggest"
        const val SEARCH_FROM_HOT = "hot"

        /**
         * 历史词
         */
        fun reportHistoryWordClick(keyWord: String, position: Int) {
            val map = HashMap<String, String>()
            map["keyword"] = keyWord
            map["index"] = position.toString()
            map["event_type"] = "history_click"
            map["search_id"] = sSearchId
            DataHelper.reportFeedClickEvent(SearchHotFragment.PAGE_NAME, map)
        }

        fun reportHistoryWordBrowse(keyword: String?, position: Int) {
            val map = HashMap<String, String>()
            map["keyword"] = keyword ?: ""
            map["index"] = position.toString()
            map["event_type"] = "history_browse"
            map["search_id"] = sSearchId
            DataHelper.reportBrowseEvent(SearchHotFragment.PAGE_NAME, map)
        }

        //历史词展开收起
        fun reportHistoryExpandClick(expandState: Boolean) {
            val map = HashMap<String, String>()
            map["isExpand"] = expandState.toString()
            map["event_type"] = "history_expand"
            map["search_id"] = sSearchId
            DataHelper.reportFeedClickEvent(SearchHotFragment.PAGE_NAME, map)
        }

        //历史词删除
        fun reportHistoryDelete() {
            DataHelper.reportFeedClickEvent(SearchHotFragment.PAGE_NAME, mapOf(
                "event_type" to "history_delete",
                "search_id" to sSearchId
            ))
        }

        /**
         * 热词
         */
        fun reportHotWordClick(keyword: String, position: Int) {
            val map = HashMap<String, String>()
            map["keyword"] = keyword
            map["index"] = position.toString()
            map["event_type"] = "hot_word_click"
            map["search_id"] = sSearchId
            DataHelper.reportFeedClickEvent(SearchHotFragment.PAGE_NAME, map)
        }

        fun reportHotWordBrowse(keyword: String?, position: Int) {
            val map = HashMap<String, String>()
            map["keyword"] = keyword ?: ""
            map["index"] = position.toString()
            map["event_type"] = "hot_word_browse"
            map["search_id"] = sSearchId
            DataHelper.reportFeedBrowseEvent(SearchHotFragment.PAGE_NAME, map)
        }

        /**
         * 热榜埋点 - 曝光
         */
        fun reportRankSubjectBrowse(hotSubject: HotSubject, position: Int,
                                    parentCategory: String, parentIndex: Int, isLowDevice: Boolean) {
            val map = HashMap<String, String>()
            map["event_type"] = "hot_rank_browse"
            map["subject_id"] = hotSubject.subjectId ?: ""
            map["index"] = position.toString()
            map["subject_type"] = hotSubject.subjectType.toString()
            map["ops"] = hotSubject.ops ?: ""
            map["lowMemoryDevice"] = isLowDevice.toString()
            map["parentTitle"] = parentCategory
            map["parentIndex"] = parentIndex.toString()
            map["search_id"] = sSearchId
            DataHelper.reportBrowseEvent(SearchHotFragment.PAGE_NAME, map)
        }

        /**
         * 热榜埋点 - 点击
         */
        fun reportRankSubjectClick(hotSubject: HotSubject, position: Int,
                                           parentCategory: String, parentIndex: Int, isLowDevice: Boolean) {
            val map = HashMap<String, String>()
            map["event_type"] = "hot_rank_click"
            map["subject_id"] = hotSubject.subjectId ?: ""
            map["index"] = position.toString()
            map["subject_type"] = hotSubject.subjectType.toString()
            map["ops"] = hotSubject.ops ?: ""
            map["lowMemoryDevice"] = isLowDevice.toString()
            map["parentTitle"] = parentCategory
            map["parentIndex"] = parentIndex.toString()
            map["search_id"] = sSearchId
            DataHelper.reportFeedClickEvent(SearchHotFragment.PAGE_NAME, map)
        }

        /**
         * 热榜埋点 - 圈子类型曝光
         */
        fun reportRankGroupBrowse(group: GroupInfo, position: Int,
                                          parentCategory: String, parentIndex: Int, isLowDevice: Boolean) {
            val map = HashMap<String, String>()
            map["event_type"] = "hot_rank_browse"
            map["group_id"] = group.groupId
            map["ops"] = group.ops
            map["index"] = position.toString()
            map["lowMemoryDevice"] = isLowDevice.toString()
            map["parentTitle"] = parentCategory
            map["parentIndex"] = parentIndex.toString()
            map["search_id"] = sSearchId
            DataHelper.reportBrowseEvent(SearchHotFragment.PAGE_NAME, map)
        }

        /*
         * 热榜埋点 - 圈子类型点击
         */
        fun reportRankGroupClick(group: GroupInfo, position: Int,
                                parentCategory: String, parentIndex: Int, isLowDevice: Boolean) {
            val map = HashMap<String, String>()
            map["event_type"] = "hot_rank_click"
            map["group_id"] = group.groupId
            map["index"] = position.toString()
            map["ops"] = group.ops
            map["lowMemoryDevice"] = isLowDevice.toString()
            map["parentTitle"] = parentCategory
            map["parentIndex"] = parentIndex.toString()
            map["search_id"] = sSearchId
            DataHelper.reportFeedClickEvent(SearchHotFragment.PAGE_NAME, map)
        }

        /**
         * 搜索联想页面 -- 曝光
         * type（推荐类型）0:联想词 1:作品 2:垂类榜单
         * key_word（搜索关键字）
         * ops（透传信息）
         * title（榜单联想模块-标题）
         * subject_id （作品形式联想词-作品ID）
         * word （标题形式联想词-标题）
         * staff_id（演员ID）
         * position（曝光的第几个）
         */
        fun reportSuggestBrowse(item: SuggestEntity?, position: Int?, keyWord: String, ops: String?) {
            kotlin.runCatching {
                val map = HashMap<String, String>()
                map["type"] = item?.type.toString() // type (推荐类型)
                map["key_word"] = keyWord // 搜索关键字
                map["ops"] = ops ?: "" // ops（透传信息）
                map["title"] = item?.word ?: "" // title（榜单联想模块-标题）
                map["subject_id"] = item?.subject?.subjectId ?: "" // subject_id （作品形式联想词-作品ID）
                map["word"] = item?.verticalRank?.title ?: "" // word （标题形式联想词-标题）
                map["index"] = position.toString() // click_position（曝光的列表第几个）
                map["search_id"] = sSearchId

                Report.reportShow(PAGE_NAME_SEARCH_SUGGEST_FRAGMENT, "browse", map)
            }
        }

        /**
         * 列表 点击事件
         * type（推荐类型）0:联想词 1:作品 2:垂类榜单
         * key_word（搜索关键字）
         * ops（透传信息）
         * title（榜单联想模块-标题）
         * subject_id （作品形式联想词-作品ID）
         * word （标题形式联想词-标题）
         * staff_id // 演员ID
         * click_position（点击的列表第几个）
         */
        fun reportSuggestClick(data: SuggestEntity?, position: Int, keyWord: String, ops: String?) {
            // 在这里统一收口 处理点击事件的上报 // 在这里上报埋点
            kotlin.runCatching {
                val map = HashMap<String, String>()
                map["type"] = data?.type.toString() // type (推荐类型)
                map["key_word"] = keyWord // 搜索关键字
                map["ops"] = ops ?: "" // ops（透传信息）
                map["title"] = data?.word ?: "" // title（榜单联想模块-标题）
                map["subject_id"] = data?.subject?.subjectId ?: "" // subject_id （作品形式联想词-作品ID）
                map["word"] = data?.verticalRank?.title ?: "" // word （标题形式联想词-标题）
                map["staff_id"] = data?.staff?.staffId ?: "" // staffId （演员ID）
                map["index"] = position.toString() // click_position（点击的列表第几个）
                map["search_id"] = sSearchId

                Report.reportClick(PAGE_NAME_SEARCH_SUGGEST_FRAGMENT, "click", map)
            }
        }


        /**
         * 结果页
         */
        fun reportTabClick(keyword: String?, tabId: String?) {
            val map = HashMap<String, String>()
            map["keyword"] = keyword ?: ""
            map["tabId"] = tabId.toString()
            map["event_type"] = "result_tab_click"
            map["search_id"] = sSearchId
            DataHelper.reportFeedClickEvent(SearchResultFragment.PAGE_NAME, map)
        }

        /**
         * 上报结果页没有结果的情况
         */
        fun reportNoResult(keyword: String?, searchFrom: String?) {
            val map = HashMap<String, String>()
            map["keyword"] = keyword ?: ""
            map["search_from"] = searchFrom ?: ""
            map["event_type"] = "result_empty"
            map["search_id"] = sSearchId
            DataHelper.reportFeedBrowseEvent(SearchResultFragment.PAGE_NAME, map)
        }

        /**
         * item的点击和曝光
         */
        fun reportSubjectBrowse(subject: Subject?, position: Int, duration: Long,
                                keyword: String?, searchFrom: String?, tabId: String?) {
            val map = HashMap<String, String>()
            map["event_type"] = "result_item_browse"
            map["keyword"] = keyword ?: ""
            map["search_from"] = searchFrom ?: ""
            map["index"] = position.toString()
            map["tabId"] = tabId.toString()
            map["duration"] = duration.toString()
            map["search_id"] = sSearchId

            map["subject_id"] = subject?.subjectId ?: ""
            map["subject_type"] = subject?.subjectType.toString()
            map["ops"] = subject?.ops ?: ""
            DataHelper.reportFeedBrowseEvent(SearchResultFragment.PAGE_NAME, map)
        }

        fun reportStaffBrowse(staff: Staff?, position: Int, duration: Long,
                              keyword: String?, searchFrom: String?, tabId: String?) {
            val map = HashMap<String, String>()
            map["event_type"] = "result_item_browse"
            map["keyword"] = keyword ?: ""
            map["search_from"] = searchFrom ?: ""
            map["index"] = position.toString()
            map["tabId"] = tabId.toString()
            map["duration"] = duration.toString()
            map["search_id"] = sSearchId

            map["staff_id"] = staff?.staffId ?: ""
            map["ops"] = staff?.ops ?: ""
            DataHelper.reportFeedBrowseEvent(SearchResultFragment.PAGE_NAME, map)
        }

        fun reportGroupBrowse(group: Group?, position: Int, duration: Long,
                              keyword: String?, searchFrom: String?, tabId: String?) {
            val map = HashMap<String, String>()
            map["event_type"] = "result_item_browse"
            map["keyword"] = keyword ?: ""
            map["search_from"] = searchFrom ?: ""
            map["index"] = position.toString()
            map["tabId"] = tabId.toString()
            map["duration"] = duration.toString()
            map["search_id"] = sSearchId

            map["group_id"] = group?.groupId ?: ""
            map["hasJoin"] = group?.hasJoin.toString()
            DataHelper.reportFeedBrowseEvent(SearchResultFragment.PAGE_NAME, map)
        }

        fun reportRankBrowse(verticalRank: VerticalRank?, position: Int, duration: Long,
                             keyword: String?, searchFrom: String?, tabId: String?) {
            val map = HashMap<String, String>()
            map["event_type"] = "result_item_browse"
            map["keyword"] = keyword ?: ""
            map["search_from"] = searchFrom ?: ""
            map["index"] = position.toString()
            map["tabId"] = tabId.toString()
            map["duration"] = duration.toString()
            map["search_id"] = sSearchId

            map["rank_title"] = verticalRank?.title ?: ""
            DataHelper.reportFeedBrowseEvent(SearchResultFragment.PAGE_NAME, map)
        }

        fun reportSubjectClick(subject: Subject?, position: Int,
                               keyword: String?, searchFrom: String?, tabId: String?) {
            val map = HashMap<String, String>()
            map["event_type"] = "result_item_click"
            map["keyword"] = keyword ?: ""
            map["search_from"] = searchFrom ?: ""
            map["index"] = position.toString()
            map["tabId"] = tabId.toString()
            map["search_id"] = sSearchId

            map["subject_id"] = subject?.subjectId ?: ""
            map["subject_type"] = subject?.subjectType.toString()
            map["ops"] = subject?.ops ?: ""
            //跳转类型
            map["jump_type"] = when{
                subject?.playUrl?.playUrl.isNullOrEmpty() -> "NOT_URL"
                else -> subject?.playUrl?.urlType.toString()
            }
            DataHelper.reportFeedClickEvent(SearchResultFragment.PAGE_NAME, map)
        }

        fun reportStaffClick(staff: Staff?, position: Int,
                             keyword: String?, searchFrom: String?, tabId: String?) {
            val map = HashMap<String, String>()
            map["event_type"] = "result_item_click"
            map["keyword"] = keyword ?: ""
            map["search_from"] = searchFrom ?: ""
            map["index"] = position.toString()
            map["tabId"] = tabId.toString()
            map["search_id"] = sSearchId

            map["staff_id"] = staff?.staffId ?: ""
            map["ops"] = staff?.ops ?: ""
            DataHelper.reportFeedClickEvent(SearchResultFragment.PAGE_NAME, map)
        }

        fun reportGroupClick(group: Group?, position: Int,
                             keyword: String?, searchFrom: String?, tabId: String?) {
            val map = HashMap<String, String>()
            map["event_type"] = "result_item_click"
            map["keyword"] = keyword ?: ""
            map["search_from"] = searchFrom ?: ""
            map["index"] = position.toString()
            map["tabId"] = tabId.toString()
            map["search_id"] = sSearchId

            map["group_id"] = group?.groupId ?: ""
            map["hasJoin"] = group?.hasJoin.toString()
            DataHelper.reportFeedClickEvent(SearchResultFragment.PAGE_NAME, map)
        }

        fun reportRankClick(verticalRank: VerticalRank?, position: Int,
                            keyword: String?, searchFrom: String?, tabId: String?) {
            val map = HashMap<String, String>()
            map["event_type"] = "result_item_click"
            map["keyword"] = keyword ?: ""
            map["search_from"] = searchFrom ?: ""
            map["index"] = position.toString()
            map["tabId"] = tabId.toString()
            map["search_id"] = sSearchId

            map["rank_title"] = verticalRank?.title ?: ""
            DataHelper.reportFeedClickEvent(SearchResultFragment.PAGE_NAME, map)
        }

        /**
         * 上报滑动间隔
         */
        fun reportResultScrollTime(tabId: String?, keyword: String?, skipTime: Long, fromIndex: Int) {
            val map = HashMap<String, String>()
            map["event_type"] = "result_scroll_skip"
            map["keyword"] = keyword ?: ""
            map["tabId"] = tabId.toString()
            map["skip_item"] = skipTime.toString()
            map["fromIndex"] = fromIndex.toString()
            map["search_id"] = sSearchId

            DataHelper.reportFeedClickEvent(SearchResultFragment.PAGE_NAME, map)
        }

        /**
         * 上报搜索结果页的换词
         */
        fun reportSearchChange(keyword: String, searchFrom: String?) {

            val map = mapOf(
                "search_from" to (searchFrom?: ""),
                "keyword" to keyword,
                "event_type" to "search",
                "search_id" to sSearchId
            )
            DataHelper.reportClickEvent(SearchResultFragment.PAGE_NAME, map)
        }
    }
}