/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.search;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.text.style.ImageSpan;
import androidx.fragment.app.FragmentActivity;
import com.alibaba.android.arouter.launcher.ARouter;
import com.transsion.baselib.utils.ExtUtilsKt;
import com.transsion.baselib.utils.PlayModeUtil;
import com.transsion.moviedetailapi.SubjectType;
import com.transsion.moviedetailapi.bean.Subject;
import com.transsion.search.R;
import com.transsnet.downloader.DownloadManagerApi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a(\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\b\u001a\u0018\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\b\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"getResultSplitSpan", "Landroid/text/style/ImageSpan;", "context", "Landroid/content/Context;", "getImageSpan", "res", "", "gotoPlayOrDownload", "", "subjectItem", "Lcom/transsion/moviedetailapi/bean/Subject;", "pageName", "playModule", "goSubjectDetail", "", "item", "isTablet", "", "resources", "Landroid/content/res/Resources;", "Search_psRelease"})
public final class SearchUtilsKt {
    @NotNull
    public static final ImageSpan getResultSplitSpan(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int subjectImageId = R.drawable.ic_search_result_split;
        return Build.VERSION.SDK_INT >= 29 ? new ImageSpan(context, subjectImageId, 2) : new ImageSpan(context, subjectImageId, 1);
    }

    @NotNull
    public static final ImageSpan getImageSpan(@NotNull Context context, int res) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Build.VERSION.SDK_INT >= 29 ? new ImageSpan(context, res, 2) : new ImageSpan(context, res, 1);
    }

    @NotNull
    public static final String gotoPlayOrDownload(@Nullable Subject subjectItem, @NotNull String pageName, @NotNull Context context, @NotNull String playModule) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)pageName, (String)"pageName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)playModule, (String)"playModule");
        String moduleName = null;
        Subject subject = subjectItem;
        if (subject != null) {
            Integer n = subject.getSubjectType();
            int n2 = SubjectType.SHORT_TV.getValue();
            bl = n != null && n == n2;
        } else {
            bl = false;
        }
        if (bl) {
            DownloadManagerApi.downloadShortTV$default((DownloadManagerApi)DownloadManagerApi.Companion.getINSTANCE(), (FragmentActivity)((FragmentActivity)context), (String)pageName, (String)"", (String)subjectItem.getOps(), (String)"download_subject", (boolean)true, (Subject)subjectItem, null, null, (int)384, null);
            moduleName = "download_subject";
        } else if (PlayModeUtil.INSTANCE.isStreamMode()) {
            SearchUtilsKt.goSubjectDetail(subjectItem, playModule);
            moduleName = "play_subject";
        } else {
            Subject subject2;
            Subject subject3 = subjectItem;
            Subject subject4 = subjectItem;
            boolean playAvailable = DownloadManagerApi.playAvailable$default((DownloadManagerApi)DownloadManagerApi.Companion.getINSTANCE(), (String)(subject3 != null ? subject3.getSubjectId() : null), (String)((subject2 = subjectItem) != null && (subject2 = subject2.getResourceDetector()) != null ? subject2.getResourceId() : null), (boolean)(subject4 != null ? subject4.isSeries() : false), (boolean)false, (int)8, null);
            if (playAvailable) {
                Object object = subjectItem;
                if (object != null && (object = object.getSubjectId()) != null) {
                    Object it = object;
                    boolean bl2 = false;
                    DownloadManagerApi.playNow$default((DownloadManagerApi)DownloadManagerApi.Companion.getINSTANCE(), (String)it, (Context)context, (String)pageName, null, (int)8, null);
                }
                moduleName = "play_subject";
            } else {
                DownloadManagerApi downloadManagerApi = DownloadManagerApi.Companion.getINSTANCE();
                FragmentActivity fragmentActivity = (FragmentActivity)context;
                Subject subject5 = subjectItem;
                String string = subject5 != null ? subject5.getOps() : null;
                Object object = subjectItem;
                if (object == null || (object = object.getResourceDetector()) == null || (object = object.getResourceLink()) == null) {
                    object = "";
                }
                DownloadManagerApi.addDownloadListWithDialog$default((DownloadManagerApi)downloadManagerApi, (FragmentActivity)fragmentActivity, (Subject)subjectItem, (String)pageName, null, (String)string, (String)object, null, null, null, (boolean)false, (int)960, null);
                moduleName = "download_subject";
            }
        }
        return moduleName;
    }

    public static final void goSubjectDetail(@Nullable Subject item, @NotNull String playModule) {
        Intrinsics.checkNotNullParameter((Object)playModule, (String)"playModule");
        if (item == null) {
            return;
        }
        if (item.isJumpBrowser()) {
            Object object = item.getPlayUrl();
            if (object != null && (object = object.getPlayUrl()) != null) {
                ExtUtilsKt.openExternalBrowser((String)object);
            }
        } else if (item.isJumpWebview()) {
            Object object = item.getPlayUrl();
            if (object != null && (object = object.getPlayUrl()) != null) {
                ExtUtilsKt.openDeeplink$default((String)object, null, (int)1, null);
            }
        } else {
            Integer n = item.getSubjectType();
            ARouter.getInstance().build("/movie/detail").withInt("subject_type", n != null ? n.intValue() : SubjectType.MOVIE.getValue()).withString("id", item.getSubjectId()).withString("module_name", playModule).withInt("season", item.getSeason()).withBoolean("autoPlay", true).withString("ops", item.getOps()).navigation();
        }
    }

    public static final boolean isTablet(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        return (resources.getConfiguration().screenLayout & 0xF) >= 3;
    }
}

