/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.search.speech;

import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import com.blankj.utilcode.util.Utils;
import com.transsion.baselib.report.LogViewConfig;
import com.transsion.baseui.R;
import com.transsion.baseui.dialog.BaseDialog;
import com.transsion.search.R;
import com.transsion.search.databinding.DialogSpeechRecognizerLayoutBinding;
import com.transsion.search.speech.InitializeStrategy;
import com.transsion.search.speech.SRErrorUtil;
import com.transsion.search.speech.SRLogger;
import com.transsion.search.speech.SRUtil;
import com.transsion.search.speech.SpeechRecognizerVolumeCircleView;
import com.transsion.search.speech.SrReport;
import com.transsion.wrapperad.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010$\u001a\u00020\u000f2\b\b\u0002\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u000fH\u0002J\b\u0010(\u001a\u00020\u000fH\u0002J\b\u0010)\u001a\u00020\u000fH\u0002J\u001a\u0010*\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010+\u001a\u00020\u0013H\u0002J\u0012\u0010,\u001a\u00020\u000f2\b\u0010-\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010.\u001a\u00020\u000fH\u0002J\b\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00072\b\u00102\u001a\u0004\u0018\u00010\u0018J1\u00103\u001a\u00020\u00002)\b\u0002\u00104\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u0007\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\n\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u0007\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lcom/transsion/search/speech/SpeechRecognizerDialog;", "Lcom/transsion/baseui/dialog/BaseDialog;", "<init>", "()V", "initializeStrategy", "Lcom/transsion/search/speech/InitializeStrategy;", "mPartialResults", "", "bind", "Lcom/transsion/search/databinding/DialogSpeechRecognizerLayoutBinding;", "mCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "result", "", "mSpeechRecognizer", "Landroid/speech/SpeechRecognizer;", "isWorking", "", "mHandler", "Landroid/os/Handler;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onViewCreated", "view", "Landroid/view/View;", "onPause", "onDismiss", "dialog", "Landroid/content/DialogInterface;", "logViewConfig", "Lcom/transsion/baselib/report/LogViewConfig;", "getLogViewConfig", "()Lcom/transsion/baselib/report/LogViewConfig;", "setSpeechTimeout", "timeout", "", "resetTimeOut", "initView", "setListener", "showResult", "isComplete", "onResult", "resultStr", "initSpeechRecognizer", "getPeekHeight", "", "analysisBundle", "bundle", "setCallback", "callback", "Search_psRelease"})
public final class SpeechRecognizerDialog
extends BaseDialog {
    @Nullable
    private InitializeStrategy initializeStrategy;
    @Nullable
    private String mPartialResults = "";
    @Nullable
    private DialogSpeechRecognizerLayoutBinding bind;
    @Nullable
    private Function1<? super String, Unit> mCallback;
    @Nullable
    private SpeechRecognizer mSpeechRecognizer;
    private boolean isWorking;
    @NotNull
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    @NotNull
    private final LogViewConfig logViewConfig = new LogViewConfig("sr_dialog", false, 2, null);

    public SpeechRecognizerDialog() {
        super(R.layout.dialog_speech_recognizer_layout);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, R.style.BottomDialogTheme);
        SRLogger.INSTANCE.logD(this.getClassTag() + " --> onCreate() --> \u5c55\u793a\u5f39\u7a97\u7ec4\u4ef6");
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Dialog dialog;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        Dialog dialog2 = this.getDialog();
        if (dialog2 != null) {
            dialog2.setCancelable(false);
        }
        if ((dialog = this.getDialog()) != null && (dialog = dialog.getWindow()) != null) {
            Dialog it = dialog;
            boolean bl = false;
            it.setGravity(80);
            it.setDimAmount(0.5f);
            it.setBackgroundDrawable(null);
            it.setWindowAnimations(R.style.BaseBottomDialogAnimation);
            it.setLayout(-1, -2);
            WindowManager.LayoutParams layoutParams = it.getAttributes();
            if (layoutParams == null) {
                layoutParams = new WindowManager.LayoutParams();
            }
            WindowManager.LayoutParams lp = layoutParams;
            lp.height = this.getPeekHeight();
        }
        this.bind = DialogSpeechRecognizerLayoutBinding.bind(view);
        this.initView();
        this.setListener();
        InitializeStrategy initializeStrategy = this.initializeStrategy = new InitializeStrategy();
        if (initializeStrategy != null) {
            initializeStrategy.setCallback((Function0<Unit>)((Function0)() -> SpeechRecognizerDialog.onViewCreated$lambda$1(this)));
        }
        this.initSpeechRecognizer();
        SRLogger.INSTANCE.logW(this.getClassTag() + " --> onViewCreated() --> \u8bed\u97f3\u8bc6\u522b\u662f\u5426\u53ef\u7528 = " + SRUtil.INSTANCE.isRecognitionAvailable());
    }

    public void onPause() {
        block0: {
            super.onPause();
            SpeechRecognizer speechRecognizer = this.mSpeechRecognizer;
            if (speechRecognizer == null) break block0;
            speechRecognizer.cancel();
        }
    }

    public void onDismiss(@NotNull DialogInterface dialog) {
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        super.onDismiss(dialog);
        try {
            Unit unit;
            boolean bl = false;
            SpeechRecognizer speechRecognizer = this.mSpeechRecognizer;
            if (speechRecognizer != null) {
                speechRecognizer.destroy();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Object object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Function1<? super String, Unit> function1 = this.mCallback;
        if (function1 != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke(null);
        }
        this.mCallback = null;
        SRLogger.INSTANCE.logD(this.getClassTag() + " --> onDismiss() --> \u8bed\u97f3\u8bc6\u522b\u5f39\u7a97\u5173\u95ed \u91ca\u653e\u8d44\u6e90");
    }

    @NotNull
    public LogViewConfig getLogViewConfig() {
        return this.logViewConfig;
    }

    private final void setSpeechTimeout(long timeout) {
        this.resetTimeOut();
        this.mHandler.postDelayed(() -> SpeechRecognizerDialog.setSpeechTimeout$lambda$3(this), timeout);
    }

    static /* synthetic */ void setSpeechTimeout$default(SpeechRecognizerDialog speechRecognizerDialog, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 5000L;
        }
        speechRecognizerDialog.setSpeechTimeout(l);
    }

    private final void resetTimeOut() {
        this.mHandler.removeCallbacksAndMessages(null);
    }

    private final void initView() {
        block3: {
            Object object;
            Object object2;
            DialogSpeechRecognizerLayoutBinding dialogSpeechRecognizerLayoutBinding;
            String string2 = Utils.getApp().getResources().getString(R.string.search_sr_speak_now);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            this.showResult(string2, false);
            Object object3 = this.bind;
            if (object3 != null && (object3 = ((DialogSpeechRecognizerLayoutBinding)object3).volumeCircleView) != null) {
                ((SpeechRecognizerVolumeCircleView)((Object)object3)).setMicState(SpeechRecognizerVolumeCircleView.MicState.ACTIVE);
            }
            if ((dialogSpeechRecognizerLayoutBinding = this.bind) != null && (dialogSpeechRecognizerLayoutBinding = dialogSpeechRecognizerLayoutBinding.tvTip) != null) {
                dialogSpeechRecognizerLayoutBinding.setText(Utils.getApp().getResources().getString(R.string.search_sr_tap_try_tip_avatar));
            }
            if ((object2 = this.bind) != null && (object2 = ((DialogSpeechRecognizerLayoutBinding)object2).volumeCircleView) != null) {
                ((SpeechRecognizerVolumeCircleView)((Object)object2)).setActiveCircleColor(Utils.getApp().getResources().getColor(R.color.white_40));
            }
            if ((object = this.bind) == null || (object = ((DialogSpeechRecognizerLayoutBinding)object).volumeCircleView) == null) break block3;
            int[] nArray = new int[]{Color.parseColor((String)"#2166E5"), Color.parseColor((String)"#1DD171")};
            ((SpeechRecognizerVolumeCircleView)((Object)object)).setLoadingGradientColors(nArray);
        }
    }

    private final void setListener() {
        block1: {
            Object object;
            DialogSpeechRecognizerLayoutBinding dialogSpeechRecognizerLayoutBinding = this.bind;
            if (dialogSpeechRecognizerLayoutBinding != null && (dialogSpeechRecognizerLayoutBinding = dialogSpeechRecognizerLayoutBinding.ivClose) != null) {
                dialogSpeechRecognizerLayoutBinding.setOnClickListener(arg_0 -> SpeechRecognizerDialog.setListener$lambda$4(this, arg_0));
            }
            if ((object = this.bind) == null || (object = object.volumeCircleView) == null) break block1;
            object.setOnClickListener(arg_0 -> SpeechRecognizerDialog.setListener$lambda$6(this, arg_0));
        }
    }

    private final void showResult(String result, boolean isComplete) {
        block2: {
            if (isComplete) {
                this.isWorking = false;
            }
            if (TextUtils.isEmpty((CharSequence)result)) {
                return;
            }
            DialogSpeechRecognizerLayoutBinding dialogSpeechRecognizerLayoutBinding = this.bind;
            if (dialogSpeechRecognizerLayoutBinding == null || (dialogSpeechRecognizerLayoutBinding = dialogSpeechRecognizerLayoutBinding.tvResult) == null) break block2;
            dialogSpeechRecognizerLayoutBinding.setText(result);
        }
    }

    static /* synthetic */ void showResult$default(SpeechRecognizerDialog speechRecognizerDialog, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        speechRecognizerDialog.showResult(string2, bl);
    }

    private final void onResult(String resultStr) {
        SrReport.INSTANCE.srSuccess();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, resultStr, null){
            int label;
            final /* synthetic */ SpeechRecognizerDialog this$0;
            final /* synthetic */ String $resultStr;
            {
                this.this$0 = $receiver;
                this.$resultStr = $resultStr;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = SpeechRecognizerDialog.access$getBind$p(this.this$0);
                        if (v0 != null && (v0 = v0.volumeCircleView) != null) {
                            v0.setMicState(SpeechRecognizerVolumeCircleView.MicState.LOADING);
                        }
                        if ((v1 = SpeechRecognizerDialog.access$getBind$p(this.this$0)) != null && (v1 = v1.tvTip) != null) {
                            v1.setText("");
                        }
                        this.label = 1;
                        v2 = DelayKt.delay((long)1500L, (Continuation)((Continuation)this));
                        if (v2 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl18:
                        // 2 sources

                        v3 = SpeechRecognizerDialog.access$getMCallback$p(this.this$0);
                        if (v3 != null) {
                            (Unit)v3.invoke((Object)this.$resultStr);
                        }
                        SpeechRecognizerDialog.access$setMCallback$p(this.this$0, null);
                        this.this$0.dismissAllowingStateLoss();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void initSpeechRecognizer() {
        block6: {
            Object object;
            try {
                Unit unit;
                boolean bl = false;
                SpeechRecognizer speechRecognizer = this.mSpeechRecognizer;
                if (speechRecognizer != null) {
                    speechRecognizer.cancel();
                }
                SpeechRecognizer speechRecognizer2 = this.mSpeechRecognizer;
                if (speechRecognizer2 != null) {
                    speechRecognizer2.destroy();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Object object2 = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            InitializeStrategy initializeStrategy = this.initializeStrategy;
            SpeechRecognizer speechRecognizer = this.mSpeechRecognizer = initializeStrategy != null ? initializeStrategy.getSpeechRecognizer(this.getContext()) : null;
            if (speechRecognizer != null) {
                speechRecognizer.setRecognitionListener(new RecognitionListener(this){
                    final /* synthetic */ SpeechRecognizerDialog this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onReadyForSpeech(Bundle params) {
                        block0: {
                            SRLogger.INSTANCE.logD(this.this$0.getClassTag() + " --> onReadyForSpeech() --> \u5f53\u8bed\u97f3\u8bc6\u522b\u51c6\u5907\u597d\u65f6\u8c03\u7528 --> params = " + params);
                            SrReport.INSTANCE.srStart();
                            InitializeStrategy initializeStrategy = SpeechRecognizerDialog.access$getInitializeStrategy$p(this.this$0);
                            if (initializeStrategy == null) break block0;
                            initializeStrategy.onReadyForSpeech();
                        }
                    }

                    public void onBeginningOfSpeech() {
                        SRLogger.INSTANCE.logD(this.this$0.getClassTag() + " --> onBeginningOfSpeech() --> \u5f53\u5f00\u59cb\u8bf4\u8bdd\u65f6\u8c03\u7528");
                    }

                    public void onRmsChanged(float rmsdB) {
                    }

                    public void onBufferReceived(byte[] buffer) {
                        SRLogger.INSTANCE.logD(this.this$0.getClassTag() + " --> onBufferReceived() --> \u5f53\u63a5\u6536\u5230\u97f3\u9891\u6570\u636e\u65f6\u8c03\u7528");
                    }

                    public void onEndOfSpeech() {
                        SRLogger.INSTANCE.logD(this.this$0.getClassTag() + " --> onEndOfSpeech() --> \u5f53\u8bf4\u8bdd\u7ed3\u675f\u65f6\u8c03\u7528");
                    }

                    public void onError(int error) {
                        block4: {
                            DialogSpeechRecognizerLayoutBinding dialogSpeechRecognizerLayoutBinding;
                            Object object;
                            if (!TextUtils.isEmpty((CharSequence)SpeechRecognizerDialog.access$getMPartialResults$p(this.this$0))) {
                                SpeechRecognizerDialog.access$onResult(this.this$0, SpeechRecognizerDialog.access$getMPartialResults$p(this.this$0));
                                return;
                            }
                            SpeechRecognizerDialog.access$resetTimeOut(this.this$0);
                            String errorMsg = SRErrorUtil.INSTANCE.getErrorMsg(error);
                            SRLogger.INSTANCE.logD(this.this$0.getClassTag() + " --> onError() --> \u5f53\u53d1\u751f\u9519\u8bef\u65f6\u8c03\u7528 --> error = " + error + " -- msg = " + errorMsg);
                            SpeechRecognizerDialog.access$showResult(this.this$0, errorMsg, true);
                            if (!SpeechRecognizerDialog.access$isWorking$p(this.this$0)) {
                                SrReport.INSTANCE.srFail(errorMsg, error);
                            } else {
                                SrReport.INSTANCE.srFail(SRErrorUtil.INSTANCE.getErrorMsg(16), 16);
                            }
                            if ((object = SpeechRecognizerDialog.access$getBind$p(this.this$0)) != null && (object = ((DialogSpeechRecognizerLayoutBinding)object).volumeCircleView) != null) {
                                ((SpeechRecognizerVolumeCircleView)((Object)object)).setMicState(SpeechRecognizerVolumeCircleView.MicState.NORMAL);
                            }
                            if ((dialogSpeechRecognizerLayoutBinding = SpeechRecognizerDialog.access$getBind$p(this.this$0)) == null || (dialogSpeechRecognizerLayoutBinding = dialogSpeechRecognizerLayoutBinding.tvTip) == null) break block4;
                            dialogSpeechRecognizerLayoutBinding.setText(Utils.getApp().getResources().getString(R.string.search_sr_tap_microphone_try_again));
                        }
                    }

                    public void onResults(Bundle results) {
                        block1: {
                            Object object = results;
                            if (object == null || (object = object.getStringArrayList("results_recognition")) == null) break block1;
                            Object object2 = object;
                            SpeechRecognizerDialog speechRecognizerDialog = this.this$0;
                            Object it = object2;
                            boolean bl = false;
                            if (!((Collection)it).isEmpty()) {
                                String resultStr = (String)((ArrayList)it).get(0);
                                Intrinsics.checkNotNull((Object)resultStr);
                                SpeechRecognizerDialog.showResult$default(speechRecognizerDialog, resultStr, false, 2, null);
                                SRLogger.INSTANCE.logD(speechRecognizerDialog.getClassTag() + " --> onResults() --> \u5f53\u83b7\u5f97\u8bed\u97f3\u8bc6\u522b\u7ed3\u679c\u65f6\u8c03\u7528 = " + resultStr);
                                SpeechRecognizerDialog.access$onResult(speechRecognizerDialog, resultStr);
                            }
                        }
                    }

                    public void onPartialResults(Bundle partialResults) {
                        block1: {
                            Object object = partialResults;
                            if (object == null || (object = object.getStringArrayList("results_recognition")) == null) break block1;
                            Object object2 = object;
                            SpeechRecognizerDialog speechRecognizerDialog = this.this$0;
                            Object it = object2;
                            boolean bl = false;
                            if (!((Collection)it).isEmpty()) {
                                SpeechRecognizerDialog.access$setMPartialResults$p(speechRecognizerDialog, (String)((ArrayList)it).get(0));
                                E e = ((ArrayList)it).get(0);
                                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                                SpeechRecognizerDialog.showResult$default(speechRecognizerDialog, (String)e, false, 2, null);
                            }
                            SpeechRecognizerDialog.setSpeechTimeout$default(speechRecognizerDialog, 0L, 1, null);
                        }
                    }

                    public void onEvent(int eventType, Bundle params) {
                        SRLogger.INSTANCE.logD(this.this$0.getClassTag() + " --> onEvent() --> \u5f53\u53d1\u751f\u5176\u4ed6\u4e8b\u4ef6\u65f6\u8c03\u7528 --> eventType = " + eventType + " --> params = " + params);
                    }
                });
            }
            if ((object = this.bind) == null || (object = object.volumeCircleView) == null) break block6;
            Object it = object;
            boolean bl = false;
            it.post(() -> SpeechRecognizerDialog.initSpeechRecognizer$lambda$9$lambda$8(this, (SpeechRecognizerVolumeCircleView)((Object)it)));
        }
    }

    private final int getPeekHeight() {
        int peekHeight = Utils.getApp().getResources().getDisplayMetrics().heightPixels;
        return peekHeight - peekHeight / 3;
    }

    @NotNull
    public final String analysisBundle(@Nullable Bundle bundle) {
        String string2;
        if (bundle != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String key : bundle.keySet()) {
                Object value = bundle.get(key);
                Object object = value;
                if (object == null || (object = object.toString()) == null) {
                    object = "null";
                }
                stringBuilder.append(key + ": " + (String)object + "\n");
                SRLogger.INSTANCE.logW("key = " + key + " -- value = " + value);
            }
            String string3 = stringBuilder.toString();
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        } else {
            string2 = "Bundle is null";
        }
        return string2;
    }

    @NotNull
    public final SpeechRecognizerDialog setCallback(@Nullable Function1<? super String, Unit> callback2) {
        this.mCallback = callback2;
        return this;
    }

    public static /* synthetic */ SpeechRecognizerDialog setCallback$default(SpeechRecognizerDialog speechRecognizerDialog, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return speechRecognizerDialog.setCallback((Function1<? super String, Unit>)function1);
    }

    private static final Unit onViewCreated$lambda$1(SpeechRecognizerDialog this$0) {
        this$0.isWorking = false;
        SRLogger.INSTANCE.logD(this$0.getClassTag() + " --> onViewCreated() --> setCallback{} --> \u91cd\u65b0\u83b7\u53d6\u8bed\u97f3\u8bc6\u522b\u5bf9\u8c61 --> initSpeechRecognizer()");
        this$0.initSpeechRecognizer();
        return Unit.INSTANCE;
    }

    private static final void setSpeechTimeout$lambda$3(SpeechRecognizerDialog this$0) {
        SpeechRecognizer speechRecognizer = this$0.mSpeechRecognizer;
        if (speechRecognizer != null) {
            speechRecognizer.stopListening();
        }
        SRLogger.INSTANCE.logD(this$0.getClassTag() + " --> setSpeechTimeout() --> \u8bed\u97f3\u8bc6\u522b\u8d85\u65f6");
    }

    private static final void setListener$lambda$4(SpeechRecognizerDialog this$0, View it) {
        SrReport.INSTANCE.clickCancelBtn();
        this$0.dismissAllowingStateLoss();
    }

    private static final void setListener$lambda$6(SpeechRecognizerDialog this$0, View it) {
        if (this$0.isWorking) {
            SpeechRecognizer speechRecognizer = this$0.mSpeechRecognizer;
            if (speechRecognizer != null) {
                speechRecognizer.stopListening();
            }
            this$0.resetTimeOut();
        } else {
            Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
            intent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
            intent.putExtra("android.speech.extra.LANGUAGE", Locale.getDefault().toLanguageTag());
            intent.putExtra("android.speech.extra.PARTIAL_RESULTS", true);
            SpeechRecognizerDialog speechRecognizerDialog = this$0;
            try {
                Unit unit;
                SpeechRecognizerDialog $this$setListener_u24lambda_u246_u24lambda_u245 = speechRecognizerDialog;
                boolean bl = false;
                SpeechRecognizer speechRecognizer = $this$setListener_u24lambda_u246_u24lambda_u245.mSpeechRecognizer;
                if (speechRecognizer != null) {
                    speechRecognizer.startListening(intent);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Object object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            SpeechRecognizerDialog.setSpeechTimeout$default(this$0, 0L, 1, null);
            this$0.initView();
        }
        this$0.isWorking = !this$0.isWorking;
    }

    private static final void initSpeechRecognizer$lambda$9$lambda$8(SpeechRecognizerDialog this$0, SpeechRecognizerVolumeCircleView $it) {
        InitializeStrategy initializeStrategy = this$0.initializeStrategy;
        if (initializeStrategy != null) {
            initializeStrategy.startListening();
        }
        $it.performClick();
    }

    public static final /* synthetic */ DialogSpeechRecognizerLayoutBinding access$getBind$p(SpeechRecognizerDialog $this) {
        return $this.bind;
    }

    public static final /* synthetic */ Function1 access$getMCallback$p(SpeechRecognizerDialog $this) {
        return $this.mCallback;
    }

    public static final /* synthetic */ void access$setMCallback$p(SpeechRecognizerDialog $this, Function1 function1) {
        $this.mCallback = function1;
    }

    public static final /* synthetic */ InitializeStrategy access$getInitializeStrategy$p(SpeechRecognizerDialog $this) {
        return $this.initializeStrategy;
    }

    public static final /* synthetic */ String access$getMPartialResults$p(SpeechRecognizerDialog $this) {
        return $this.mPartialResults;
    }

    public static final /* synthetic */ void access$onResult(SpeechRecognizerDialog $this, String resultStr) {
        $this.onResult(resultStr);
    }

    public static final /* synthetic */ void access$resetTimeOut(SpeechRecognizerDialog $this) {
        $this.resetTimeOut();
    }

    public static final /* synthetic */ void access$showResult(SpeechRecognizerDialog $this, String result, boolean isComplete) {
        $this.showResult(result, isComplete);
    }

    public static final /* synthetic */ boolean access$isWorking$p(SpeechRecognizerDialog $this) {
        return $this.isWorking;
    }

    public static final /* synthetic */ void access$setMPartialResults$p(SpeechRecognizerDialog $this, String string2) {
        $this.mPartialResults = string2;
    }
}

