/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.search.speech;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import com.transsion.search.R;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u00012B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020 H\u0014J\u000e\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\tJ\u000e\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u0010J\u000e\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u0010J\u000e\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u000eJ\u000e\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020\u0010J\u000e\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u0015J\u000e\u00101\u001a\u00020 2\u0006\u0010*\u001a\u00020\u0010R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/transsion/search/speech/SpeechRecognizerVolumeCircleView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "mMicState", "Lcom/transsion/search/speech/SpeechRecognizerVolumeCircleView$MicState;", "mActiveAnnulusRadius", "", "mLoadingAngle", "mActiveAnimationDuration", "", "mMicIconSize", "", "mScaledMicIconNormal", "Landroid/graphics/Bitmap;", "mScaledMicIconActive", "mLoadingGradientColors", "", "mMicIconNormal", "mMicIconActive", "mActivePaint", "Landroid/graphics/Paint;", "mLoadingPaint", "mActiveRadiusAnimator", "Landroid/animation/ValueAnimator;", "dpToPx", "dp", "startActiveRadiusAnimation", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onDetachedFromWindow", "setMicState", "state", "setActiveCircleColor", "color", "setActiveStrokeWidth", "widthDp", "setActiveAnimationDuration", "duration", "setMicIconSize", "size", "setLoadingGradientColors", "colors", "setLoadingStrokeWidth", "MicState", "Search_psRelease"})
public final class SpeechRecognizerVolumeCircleView
extends View {
    @NotNull
    private MicState mMicState;
    private float mActiveAnnulusRadius;
    private float mLoadingAngle;
    private long mActiveAnimationDuration;
    private int mMicIconSize;
    @NotNull
    private Bitmap mScaledMicIconNormal;
    @NotNull
    private Bitmap mScaledMicIconActive;
    @NotNull
    private int[] mLoadingGradientColors;
    @NotNull
    private final Bitmap mMicIconNormal;
    @NotNull
    private final Bitmap mMicIconActive;
    @NotNull
    private final Paint mActivePaint;
    @NotNull
    private final Paint mLoadingPaint;
    @NotNull
    private final ValueAnimator mActiveRadiusAnimator;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public SpeechRecognizerVolumeCircleView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void $this$mActiveRadiusAnimator_u24lambda_u243;
        Object $this$mLoadingPaint_u24lambda_u241;
        Object $this$mActivePaint_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.mMicState = MicState.NORMAL;
        this.mActiveAnimationDuration = 1000L;
        this.mMicIconSize = this.dpToPx(80);
        Object object = new int[]{Color.parseColor((String)"#2166E5"), Color.parseColor((String)"#1DD171")};
        this.mLoadingGradientColors = object;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.mipmap.sr_icon_normal);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeResource(...)");
        this.mMicIconNormal = bitmap;
        Bitmap bitmap2 = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.mipmap.sr_icon_active);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"decodeResource(...)");
        this.mMicIconActive = bitmap2;
        Object object2 = object = (Object)new Paint();
        SpeechRecognizerVolumeCircleView speechRecognizerVolumeCircleView = this;
        boolean bl = false;
        $this$mActivePaint_u24lambda_u240.setColor(-65536);
        $this$mActivePaint_u24lambda_u240.setStyle(Paint.Style.STROKE);
        $this$mActivePaint_u24lambda_u240.setStrokeWidth(context.getResources().getDisplayMetrics().density);
        $this$mActivePaint_u24lambda_u240.setAntiAlias(true);
        speechRecognizerVolumeCircleView.mActivePaint = (Paint)object;
        $this$mActivePaint_u24lambda_u240 = object = (Object)new Paint();
        speechRecognizerVolumeCircleView = this;
        boolean bl2 = false;
        $this$mLoadingPaint_u24lambda_u241.setStyle(Paint.Style.STROKE);
        $this$mLoadingPaint_u24lambda_u241.setStrokeWidth((float)this.dpToPx(2));
        $this$mLoadingPaint_u24lambda_u241.setAntiAlias(true);
        speechRecognizerVolumeCircleView.mLoadingPaint = (Paint)object;
        $this$mLoadingPaint_u24lambda_u241 = object = (Object)new ValueAnimator();
        speechRecognizerVolumeCircleView = this;
        boolean bl3 = false;
        $this$mActiveRadiusAnimator_u24lambda_u243.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        $this$mActiveRadiusAnimator_u24lambda_u243.addUpdateListener(arg_0 -> SpeechRecognizerVolumeCircleView.mActiveRadiusAnimator$lambda$3$lambda$2(this, arg_0));
        speechRecognizerVolumeCircleView.mActiveRadiusAnimator = (ValueAnimator)object;
        Bitmap bitmap3 = Bitmap.createScaledBitmap((Bitmap)this.mMicIconNormal, (int)this.mMicIconSize, (int)this.mMicIconSize, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createScaledBitmap(...)");
        this.mScaledMicIconNormal = bitmap3;
        Bitmap bitmap4 = Bitmap.createScaledBitmap((Bitmap)this.mMicIconActive, (int)this.mMicIconSize, (int)this.mMicIconSize, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"createScaledBitmap(...)");
        this.mScaledMicIconActive = bitmap4;
        this.setLoadingGradientColors(this.mLoadingGradientColors);
    }

    public /* synthetic */ SpeechRecognizerVolumeCircleView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    private final int dpToPx(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    private final void startActiveRadiusAnimation() {
        float iconRadius = this.mMicIconSize / 2;
        float maxRadius = (float)(Math.min(this.getWidth(), this.getHeight()) / 2) - this.mActivePaint.getStrokeWidth() / (float)2;
        float[] fArray = new float[]{iconRadius, maxRadius};
        this.mActiveRadiusAnimator.setFloatValues(fArray);
        this.mActiveRadiusAnimator.setDuration(this.mActiveAnimationDuration);
        this.mActiveRadiusAnimator.setRepeatCount(-1);
        this.mActiveRadiusAnimator.start();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        switch (WhenMappings.$EnumSwitchMapping$0[this.mMicState.ordinal()]) {
            case 1: {
                float cx = this.getWidth() / 2;
                float cy = this.getHeight() / 2;
                float loadingRadius = this.mMicIconSize / 2;
                canvas.drawArc(cx - loadingRadius, cy - loadingRadius, cx + loadingRadius, cy + loadingRadius, this.mLoadingAngle, 270.0f, false, this.mLoadingPaint);
                this.mLoadingAngle += 5.0f;
                if (this.mLoadingAngle > 360.0f) {
                    this.mLoadingAngle = 0.0f;
                }
                this.postInvalidateOnAnimation();
                break;
            }
            case 2: {
                Bitmap micIcon = this.mScaledMicIconActive;
                int iconLeft = (this.getWidth() - this.mMicIconSize) / 2;
                int iconTop = (this.getHeight() - this.mMicIconSize) / 2;
                float cx = iconLeft + this.mMicIconSize / 2;
                float cy = iconTop + this.mMicIconSize / 2;
                canvas.drawCircle(cx, cy, this.mActiveAnnulusRadius, this.mActivePaint);
                canvas.drawBitmap(micIcon, (float)iconLeft, (float)iconTop, null);
                break;
            }
            default: {
                Bitmap micIcon = this.mScaledMicIconNormal;
                int iconLeft = (this.getWidth() - this.mMicIconSize) / 2;
                int iconTop = (this.getHeight() - this.mMicIconSize) / 2;
                canvas.drawBitmap(micIcon, (float)iconLeft, (float)iconTop, null);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mActiveRadiusAnimator.cancel();
    }

    public final void setMicState(@NotNull MicState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.mMicState = state;
        if (this.mMicState == MicState.ACTIVE) {
            this.startActiveRadiusAnimation();
        } else {
            this.mActiveRadiusAnimator.cancel();
        }
        this.invalidate();
    }

    public final void setActiveCircleColor(int color2) {
        this.mActivePaint.setColor(color2);
        this.invalidate();
    }

    public final void setActiveStrokeWidth(int widthDp) {
        this.mActivePaint.setStrokeWidth((float)this.dpToPx(widthDp));
        this.invalidate();
    }

    public final void setActiveAnimationDuration(long duration) {
        this.mActiveAnimationDuration = duration;
    }

    public final void setMicIconSize(int size) {
        this.mMicIconSize = this.dpToPx(size);
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)this.mMicIconNormal, (int)this.mMicIconSize, (int)this.mMicIconSize, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createScaledBitmap(...)");
        this.mScaledMicIconNormal = bitmap;
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)this.mMicIconActive, (int)this.mMicIconSize, (int)this.mMicIconSize, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createScaledBitmap(...)");
        this.mScaledMicIconActive = bitmap2;
        this.invalidate();
    }

    public final void setLoadingGradientColors(@NotNull int[] colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.mLoadingGradientColors = colors;
        float cx = this.getWidth() / 2;
        float cy = this.getHeight() / 2;
        Object[] objectArray = new int[]{colors[0], colors[1], colors[1], colors[0]};
        int[] nArray = objectArray;
        objectArray = new float[4];
        objectArray[0] = (int)0.0f;
        objectArray[1] = (int)0.5f;
        objectArray[2] = (int)0.75f;
        objectArray[3] = (int)1.0f;
        this.mLoadingPaint.setShader((Shader)new SweepGradient(cx, cy, nArray, (float[])objectArray));
        this.invalidate();
    }

    public final void setLoadingStrokeWidth(int widthDp) {
        this.mLoadingPaint.setStrokeWidth((float)this.dpToPx(widthDp));
        this.invalidate();
    }

    @JvmOverloads
    public SpeechRecognizerVolumeCircleView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    private static final void mActiveRadiusAnimator$lambda$3$lambda$2(SpeechRecognizerVolumeCircleView this$0, ValueAnimator animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Object object = animation.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        this$0.mActiveAnnulusRadius = ((Float)object).floatValue();
        float fraction = animation.getAnimatedFraction();
        this$0.mActivePaint.setAlpha((double)fraction <= 0.5 ? (int)((double)255 * (1.0 - 0.5 * (double)fraction)) : (int)((double)255 * (0.5 - 0.5 * ((double)fraction - 0.5))));
        this$0.invalidate();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/transsion/search/speech/SpeechRecognizerVolumeCircleView$MicState;", "", "<init>", "(Ljava/lang/String;I)V", "NORMAL", "ACTIVE", "LOADING", "Search_psRelease"})
    public static final class MicState
    extends Enum<MicState> {
        public static final /* enum */ MicState NORMAL = new MicState();
        public static final /* enum */ MicState ACTIVE = new MicState();
        public static final /* enum */ MicState LOADING = new MicState();
        private static final /* synthetic */ MicState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MicState[] values() {
            return (MicState[])$VALUES.clone();
        }

        public static MicState valueOf(String value) {
            return Enum.valueOf(MicState.class, value);
        }

        @NotNull
        public static EnumEntries<MicState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = micStateArray = new MicState[]{MicState.NORMAL, MicState.ACTIVE, MicState.LOADING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MicState.values().length];
            try {
                nArray[MicState.LOADING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MicState.ACTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

