/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.search.viewmodel;

import android.app.Application;
import android.text.TextUtils;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import com.blankj.utilcode.util.Utils;
import com.tn.lib.logger.Logger;
import com.tn.lib.net.base.BaseObserver;
import com.tn.lib.net.bean.BaseDto;
import com.tn.lib.util.networkinfo.NetworkUtil;
import com.tn.lib.widget.R;
import com.tn.lib.widget.toast.core.ToastUtils;
import com.transsion.baselib.report.Report;
import com.transsion.search.activity.SearchManagerActivity;
import com.transsion.search.bean.HotSubjectEntity;
import com.transsion.search.bean.JoinGroupEntity;
import com.transsion.search.bean.SearchGroupEntity;
import com.transsion.search.bean.SearchSuggestEntity;
import com.transsion.search.bean.SearchWorkEntity;
import com.transsion.search.bean.SuggestEntity;
import com.transsion.search.net.RequestJoinGroupEntity;
import com.transsion.search.net.RequestSearchEntity;
import com.transsion.search.net.SearchModel;
import com.transsion.search.widget.BoundaryLinkedHashMap;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007J\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007J\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007J\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007J\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0007J\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\rJ&\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\r2\u0006\u0010'\u001a\u00020#J\u001e\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\rJ\u000e\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020\rJ\u0006\u0010+\u001a\u00020!J\u000e\u00104\u001a\u00020!2\u0006\u0010%\u001a\u00020\rJ\b\u00105\u001a\u00020!H\u0014R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010/R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u0012\u00a8\u00066"}, d2={"Lcom/transsion/search/viewmodel/SearchViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "<init>", "(Landroid/app/Application;)V", "mGroupsLiveData", "Landroidx/lifecycle/MutableLiveData;", "Lcom/transsion/search/bean/SearchGroupEntity;", "mWorksLiveData", "Lcom/transsion/search/bean/SearchWorkEntity;", "mWorksLiveDataV2", "mJoinGroupLiveData", "", "mGroupsRecommendLiveData", "hotSubjectLiveData", "Lcom/transsion/search/bean/HotSubjectEntity;", "getHotSubjectLiveData", "()Landroidx/lifecycle/MutableLiveData;", "searchApi", "Lcom/transsion/search/net/SearchModel;", "getSearchApi", "()Lcom/transsion/search/net/SearchModel;", "searchApi$delegate", "Lkotlin/Lazy;", "getSearchGroupLiveData", "getSearchWorkLiveData", "getSearchWorkLiveDataV2", "getGroupRecommendLiveData", "getJoinGroupLiveData", "mFollowDisposable", "Lio/reactivex/rxjava3/disposables/Disposable;", "searchWork", "", "page", "", "perPage", "keyword", "searchWorkV2", "subjectType", "searchGroup", "joinGroup", "groupId", "getHotSubject", "suggestMap", "Lcom/transsion/search/widget/BoundaryLinkedHashMap;", "getSuggestMap", "()Lcom/transsion/search/widget/BoundaryLinkedHashMap;", "suggestFailureMap", "getSuggestFailureMap", "suggestLiveData", "getSuggestLiveData", "getSearchSuggest", "onCleared", "Search_psRelease"})
public final class SearchViewModel
extends AndroidViewModel {
    @NotNull
    private final MutableLiveData<SearchGroupEntity> mGroupsLiveData;
    @NotNull
    private final MutableLiveData<SearchWorkEntity> mWorksLiveData;
    @NotNull
    private final MutableLiveData<SearchWorkEntity> mWorksLiveDataV2;
    @NotNull
    private final MutableLiveData<String> mJoinGroupLiveData;
    @NotNull
    private final MutableLiveData<SearchGroupEntity> mGroupsRecommendLiveData;
    @NotNull
    private final MutableLiveData<HotSubjectEntity> hotSubjectLiveData;
    @NotNull
    private final Lazy searchApi$delegate;
    @Nullable
    private Disposable mFollowDisposable;
    @NotNull
    private final BoundaryLinkedHashMap suggestMap;
    @NotNull
    private final BoundaryLinkedHashMap suggestFailureMap;
    @NotNull
    private final MutableLiveData<String> suggestLiveData;

    public SearchViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        this.mGroupsLiveData = new MutableLiveData();
        this.mWorksLiveData = new MutableLiveData();
        this.mWorksLiveDataV2 = new MutableLiveData();
        this.mJoinGroupLiveData = new MutableLiveData();
        this.mGroupsRecommendLiveData = new MutableLiveData();
        this.hotSubjectLiveData = new MutableLiveData();
        this.searchApi$delegate = LazyKt.lazy(SearchViewModel::searchApi_delegate$lambda$0);
        this.suggestMap = new BoundaryLinkedHashMap();
        this.suggestFailureMap = new BoundaryLinkedHashMap();
        this.suggestLiveData = new MutableLiveData();
    }

    @NotNull
    public final MutableLiveData<HotSubjectEntity> getHotSubjectLiveData() {
        return this.hotSubjectLiveData;
    }

    private final SearchModel getSearchApi() {
        Lazy lazy = this.searchApi$delegate;
        return (SearchModel)lazy.getValue();
    }

    @NotNull
    public final MutableLiveData<SearchGroupEntity> getSearchGroupLiveData() {
        return this.mGroupsLiveData;
    }

    @NotNull
    public final MutableLiveData<SearchWorkEntity> getSearchWorkLiveData() {
        return this.mWorksLiveData;
    }

    @NotNull
    public final MutableLiveData<SearchWorkEntity> getSearchWorkLiveDataV2() {
        return this.mWorksLiveDataV2;
    }

    @NotNull
    public final MutableLiveData<SearchGroupEntity> getGroupRecommendLiveData() {
        return this.mGroupsRecommendLiveData;
    }

    @NotNull
    public final MutableLiveData<String> getJoinGroupLiveData() {
        return this.mJoinGroupLiveData;
    }

    public final void searchWork(int page, int perPage, @NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        RequestSearchEntity request = new RequestSearchEntity(page, perPage, keyword);
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
            int label;
            final /* synthetic */ SearchViewModel this$0;
            final /* synthetic */ RequestSearchEntity $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 /* !! */  = this.this$0;
                        var3_4 /* !! */  = this.$request;
                        $i$a$-runCatching-SearchViewModel$searchWork$1$1 = false;
                        this.label = 1;
                        v0 = SearchViewModel.access$getSearchApi(var2_3 /* !! */ ).searchSubject(var3_4 /* !! */ , (Continuation<? super BaseDto<SearchWorkEntity>>)this);
                        ** if (v0 != var10_2) goto lbl15
lbl14:
                        // 1 sources

                        return var10_2;
lbl15:
                        // 1 sources

                        ** GOTO lbl22
                    }
                    case 1: {
                        $i$a$-runCatching-SearchViewModel$searchWork$1$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl22:
                            // 2 sources

                            $i$a$-runCatching-SearchViewModel$searchWork$1$1 = Result.constructor-impl((Object)((BaseDto)v0));
                        }
                        catch (Throwable var5_7) {
                            $i$a$-runCatching-SearchViewModel$searchWork$1$1 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var5_7));
                        }
                        var2_3 /* !! */  = $i$a$-runCatching-SearchViewModel$searchWork$1$1;
                        var3_4 /* !! */  = this.this$0;
                        it /* !! */  = var2_3 /* !! */ ;
                        $i$a$-let-SearchViewModel$searchWork$1$2 = false;
                        var6_9 /* !! */  = it /* !! */ ;
                        if (Result.isSuccess-impl((Object)var6_9 /* !! */ )) {
                            baseDto = (BaseDto)var6_9 /* !! */ ;
                            $i$a$-onSuccess-SearchViewModel$searchWork$1$2$1 = false;
                            SearchViewModel.access$getMWorksLiveData$p((SearchViewModel)var3_4 /* !! */ ).postValue(baseDto.getData());
                        }
                        var6_9 /* !! */  = it /* !! */ ;
                        v1 = Result.exceptionOrNull-impl((Object)var6_9 /* !! */ );
                        if (v1 != null) {
                            it = var7_10 = v1;
                            $i$a$-onFailure-SearchViewModel$searchWork$1$2$2 = false;
                            Logger.Companion.w$default((Logger.Companion)Logger.Companion, (String)"liup", (String)String.valueOf(it.getMessage()), (boolean)false, (int)4, null);
                            if (NetworkUtil.INSTANCE.hasCapabilityAsync()) {
                                ToastUtils.INSTANCE.show((CharSequence)Utils.getApp().getString(R.string.no_error_content));
                            } else {
                                ToastUtils.INSTANCE.show((CharSequence)Utils.getApp().getString(R.string.no_network_toast));
                            }
                            SearchViewModel.access$getMWorksLiveData$p((SearchViewModel)var3_4 /* !! */ ).postValue(null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void searchWorkV2(int page, int perPage, @NotNull String keyword, int subjectType) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        RequestSearchEntity request = new RequestSearchEntity(page, perPage, keyword, subjectType);
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
            int label;
            final /* synthetic */ SearchViewModel this$0;
            final /* synthetic */ RequestSearchEntity $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 /* !! */  = this.this$0;
                        var3_4 /* !! */  = this.$request;
                        $i$a$-runCatching-SearchViewModel$searchWorkV2$1$1 = false;
                        this.label = 1;
                        v0 = SearchViewModel.access$getSearchApi(var2_3 /* !! */ ).searchSubject(var3_4 /* !! */ , (Continuation<? super BaseDto<SearchWorkEntity>>)this);
                        ** if (v0 != var10_2) goto lbl15
lbl14:
                        // 1 sources

                        return var10_2;
lbl15:
                        // 1 sources

                        ** GOTO lbl22
                    }
                    case 1: {
                        $i$a$-runCatching-SearchViewModel$searchWorkV2$1$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl22:
                            // 2 sources

                            $i$a$-runCatching-SearchViewModel$searchWorkV2$1$1 = Result.constructor-impl((Object)((BaseDto)v0));
                        }
                        catch (Throwable var5_7) {
                            $i$a$-runCatching-SearchViewModel$searchWorkV2$1$1 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var5_7));
                        }
                        var2_3 /* !! */  = $i$a$-runCatching-SearchViewModel$searchWorkV2$1$1;
                        var3_4 /* !! */  = this.this$0;
                        it /* !! */  = var2_3 /* !! */ ;
                        $i$a$-let-SearchViewModel$searchWorkV2$1$2 = false;
                        var6_9 /* !! */  = it /* !! */ ;
                        if (Result.isSuccess-impl((Object)var6_9 /* !! */ )) {
                            baseDto = (BaseDto)var6_9 /* !! */ ;
                            $i$a$-onSuccess-SearchViewModel$searchWorkV2$1$2$1 = false;
                            SearchViewModel.access$getMWorksLiveDataV2$p((SearchViewModel)var3_4 /* !! */ ).postValue(baseDto.getData());
                        }
                        var6_9 /* !! */  = it /* !! */ ;
                        v1 = Result.exceptionOrNull-impl((Object)var6_9 /* !! */ );
                        if (v1 != null) {
                            var7_10 = v1;
                            $i$a$-onFailure-SearchViewModel$searchWorkV2$1$2$2 = false;
                            if (NetworkUtil.INSTANCE.hasCapabilityAsync()) {
                                ToastUtils.INSTANCE.show((CharSequence)Utils.getApp().getString(R.string.no_error_content));
                            } else {
                                ToastUtils.INSTANCE.show((CharSequence)Utils.getApp().getString(R.string.no_network_toast));
                            }
                            SearchViewModel.access$getMWorksLiveDataV2$p((SearchViewModel)var3_4 /* !! */ ).postValue(null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void searchGroup(int page, int perPage, @NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        RequestSearchEntity request = new RequestSearchEntity(page, perPage, keyword);
        this.getSearchApi().searchGroup(request).subscribeOn(Schedulers.io()).subscribe((Observer)new BaseObserver<SearchGroupEntity>(this){
            final /* synthetic */ SearchViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFailure(String code, String message) {
                String string2 = message;
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    ToastUtils.INSTANCE.show((CharSequence)it);
                }
                SearchViewModel.access$getMGroupsLiveData$p(this.this$0).postValue(null);
            }

            public void onSuccess2(BaseDto<SearchGroupEntity> baseDto) {
                Intrinsics.checkNotNullParameter(baseDto, (String)"baseDto");
                SearchViewModel.access$getMGroupsLiveData$p(this.this$0).postValue(baseDto.getData());
            }
        });
    }

    public final void joinGroup(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        RequestJoinGroupEntity request = new RequestJoinGroupEntity(groupId);
        this.getSearchApi().joinGroup(request).subscribeOn(Schedulers.io()).subscribe((Observer)new BaseObserver<JoinGroupEntity>(this){
            final /* synthetic */ SearchViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFailure(String code, String message) {
                String string2 = message;
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    ToastUtils.INSTANCE.show((CharSequence)it);
                }
                SearchViewModel.access$getMJoinGroupLiveData$p(this.this$0).postValue((Object)"");
            }

            public void onSuccess(JoinGroupEntity data) {
                JoinGroupEntity joinGroupEntity = data;
                if (TextUtils.isEmpty((CharSequence)(joinGroupEntity != null ? joinGroupEntity.getM() : null))) {
                    SearchViewModel.access$getMJoinGroupLiveData$p(this.this$0).postValue((Object)"succeed");
                    return;
                }
                JoinGroupEntity joinGroupEntity2 = data;
                SearchViewModel.access$getMJoinGroupLiveData$p(this.this$0).postValue((Object)(joinGroupEntity2 != null ? joinGroupEntity2.getM() : null));
            }

            public void onSuccess2(BaseDto<JoinGroupEntity> baseDto) {
                Intrinsics.checkNotNullParameter(baseDto, (String)"baseDto");
            }
        });
    }

    public final void getHotSubject() {
        this.getSearchApi().getHotSubject().subscribeOn(Schedulers.io()).subscribe((Observer)new BaseObserver<HotSubjectEntity>(this){
            final /* synthetic */ SearchViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFailure(String code, String message) {
                this.this$0.getHotSubjectLiveData().postValue(null);
            }

            public void onSuccess(HotSubjectEntity data) {
                this.this$0.getHotSubjectLiveData().postValue((Object)data);
            }
        });
    }

    @NotNull
    public final BoundaryLinkedHashMap getSuggestMap() {
        return this.suggestMap;
    }

    @NotNull
    public final BoundaryLinkedHashMap getSuggestFailureMap() {
        return this.suggestFailureMap;
    }

    @NotNull
    public final MutableLiveData<String> getSuggestLiveData() {
        return this.suggestLiveData;
    }

    public final void getSearchSuggest(@NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        this.getSearchApi().getSearchSuggest(keyword).subscribeOn(Schedulers.io()).subscribe((Observer)new BaseObserver<SearchSuggestEntity>(this, keyword){
            final /* synthetic */ SearchViewModel this$0;
            final /* synthetic */ String $keyword;
            {
                this.this$0 = $receiver;
                this.$keyword = $keyword;
            }

            public void onFailure(String code, String message) {
                this.this$0.getSuggestLiveData().postValue((Object)this.$keyword);
            }

            public void onSuccess(SearchSuggestEntity data) {
                block4: {
                    SearchSuggestEntity searchSuggestEntity = data;
                    if (searchSuggestEntity == null) break block4;
                    SearchSuggestEntity searchSuggestEntity2 = searchSuggestEntity;
                    SearchViewModel searchViewModel = this.this$0;
                    String string2 = this.$keyword;
                    SearchSuggestEntity it = searchSuggestEntity2;
                    boolean bl = false;
                    ((Map)searchViewModel.getSuggestMap()).put(it.getKeyword(), it);
                    searchViewModel.getSuggestLiveData().postValue((Object)string2);
                    List<SuggestEntity> list2 = it.getItems();
                    boolean bl2 = list2 != null ? list2.isEmpty() : false;
                    if (bl2) {
                        String string3 = it.getKeyword();
                        if ((string3 != null ? string3.length() : 0) >= 2 && !searchViewModel.getSuggestFailureMap().containsKey(it.getKeyword())) {
                            ((Map)searchViewModel.getSuggestFailureMap()).put(it.getKeyword(), null);
                            SearchManagerActivity.Companion.log("no associative word results when the user enters query longer than 2 characters");
                            HashMap<K, V> map = new HashMap<K, V>();
                            Map map2 = map;
                            String string4 = "key_word";
                            String string5 = it.getKeyword();
                            if (string5 == null) {
                                string5 = "";
                            }
                            String string6 = string5;
                            map2.put(string4, string6);
                            map2 = map;
                            string4 = "ops";
                            String string7 = it.getOps();
                            if (string7 == null) {
                                string7 = "";
                            }
                            string6 = string7;
                            map2.put(string4, string6);
                            Report.INSTANCE.reportShow("search_suggest", "browse", (Map)map);
                        }
                    }
                }
            }
        });
    }

    protected void onCleared() {
        block1: {
            super.onCleared();
            Disposable disposable = this.mFollowDisposable;
            boolean bl = disposable != null ? !disposable.isDisposed() : false;
            if (!bl) break block1;
            Disposable disposable2 = this.mFollowDisposable;
            if (disposable2 != null) {
                disposable2.dispose();
            }
        }
    }

    private static final SearchModel searchApi_delegate$lambda$0() {
        return new SearchModel();
    }

    public static final /* synthetic */ SearchModel access$getSearchApi(SearchViewModel $this) {
        return $this.getSearchApi();
    }

    public static final /* synthetic */ MutableLiveData access$getMWorksLiveData$p(SearchViewModel $this) {
        return $this.mWorksLiveData;
    }

    public static final /* synthetic */ MutableLiveData access$getMWorksLiveDataV2$p(SearchViewModel $this) {
        return $this.mWorksLiveDataV2;
    }

    public static final /* synthetic */ MutableLiveData access$getMGroupsLiveData$p(SearchViewModel $this) {
        return $this.mGroupsLiveData;
    }

    public static final /* synthetic */ MutableLiveData access$getMJoinGroupLiveData$p(SearchViewModel $this) {
        return $this.mJoinGroupLiveData;
    }
}

