/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.share.api;

import android.app.Application;
import android.text.TextUtils;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.gson.JsonObject;
import com.tn.lib.net.base.BaseObserver;
import com.tn.lib.net.base.BaseScheduler;
import com.tn.lib.net.env.Host;
import com.tn.lib.net.manager.NetServiceGenerator;
import com.transsion.share.api.IActionApi;
import com.transsion.share.bean.LikeEntity;
import com.transsion.share.bean.ShareBean;
import com.transsion.share.bean.ShareType;
import io.reactivex.rxjava3.core.Observer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0014J\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0014J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007J\u0016\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020 R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/transsion/share/api/ActionViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "<init>", "(Landroid/app/Application;)V", "TAG", "", "shareLiveData", "Landroidx/lifecycle/MutableLiveData;", "Lcom/transsion/share/bean/ShareBean;", "likeLiveData", "Lcom/transsion/share/bean/LikeEntity;", "actionApi", "Lcom/transsion/share/api/IActionApi;", "getActionApi", "()Lcom/transsion/share/api/IActionApi;", "actionApi$delegate", "Lkotlin/Lazy;", "getShareLiveData", "Landroidx/lifecycle/LiveData;", "getLikeLiveData", "share", "", "shareType", "Lcom/transsion/share/bean/ShareType;", "postType", "subjectId", "uid", "scene", "like", "postId", "", "ShareLib_psRelease"})
public final class ActionViewModel
extends AndroidViewModel {
    @NotNull
    private final String TAG;
    @NotNull
    private final MutableLiveData<ShareBean> shareLiveData;
    @NotNull
    private final MutableLiveData<LikeEntity> likeLiveData;
    @NotNull
    private final Lazy actionApi$delegate;

    public ActionViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        this.TAG = "ActionViewModel";
        this.shareLiveData = new MutableLiveData();
        this.likeLiveData = new MutableLiveData();
        this.actionApi$delegate = LazyKt.lazy(ActionViewModel::actionApi_delegate$lambda$0);
    }

    private final IActionApi getActionApi() {
        Lazy lazy = this.actionApi$delegate;
        return (IActionApi)lazy.getValue();
    }

    @NotNull
    public final LiveData<ShareBean> getShareLiveData() {
        return (LiveData)this.shareLiveData;
    }

    @NotNull
    public final LiveData<LikeEntity> getLikeLiveData() {
        return (LiveData)this.likeLiveData;
    }

    public final void share(@NotNull ShareType shareType, @NotNull String postType, @NotNull String subjectId, @NotNull String uid, @NotNull String scene) {
        Intrinsics.checkNotNullParameter((Object)((Object)shareType), (String)"shareType");
        Intrinsics.checkNotNullParameter((Object)postType, (String)"postType");
        Intrinsics.checkNotNullParameter((Object)subjectId, (String)"subjectId");
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
        if (TextUtils.isEmpty((CharSequence)subjectId)) {
            return;
        }
        JsonObject json = new JsonObject();
        json.addProperty("uid", uid);
        json.addProperty("type", postType);
        json.addProperty("scene", scene);
        json.addProperty("id", subjectId);
        String string = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        RequestBody body = RequestBody.Companion.create(string, MediaType.Companion.parse("application/json"));
        this.getActionApi().subjectShare(Host.Companion.getHost(), body).compose(BaseScheduler.INSTANCE.compose()).subscribe((Observer)new BaseObserver<ShareBean>(this, shareType){
            final /* synthetic */ ActionViewModel this$0;
            final /* synthetic */ ShareType $shareType;
            {
                this.this$0 = $receiver;
                this.$shareType = $shareType;
            }

            public void onFailure(String code, String message) {
                ActionViewModel.access$getShareLiveData$p(this.this$0).setValue(null);
            }

            public void onSuccess(ShareBean data) {
                ShareBean shareBean = data;
                if (shareBean != null) {
                    shareBean.setShareType(this.$shareType);
                }
                ActionViewModel.access$getShareLiveData$p(this.this$0).setValue((Object)data);
            }
        });
    }

    public final void like(@NotNull String postId, boolean like2) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        if (TextUtils.isEmpty((CharSequence)postId)) {
            return;
        }
        JsonObject json = new JsonObject();
        json.addProperty("postId", postId);
        if (like2) {
            json.addProperty("reqType", (Number)0);
        } else {
            json.addProperty("reqType", (Number)1);
        }
        String string = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        RequestBody body = RequestBody.Companion.create(string, MediaType.Companion.parse("application/json"));
        this.getActionApi().like(Host.Companion.getHost(), body).compose(BaseScheduler.INSTANCE.compose()).subscribe((Observer)new BaseObserver<LikeEntity>(this){
            final /* synthetic */ ActionViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFailure(String code, String message) {
                ActionViewModel.access$getLikeLiveData$p(this.this$0).setValue(null);
            }

            public void onSuccess(LikeEntity data) {
                ActionViewModel.access$getLikeLiveData$p(this.this$0).setValue((Object)data);
            }
        });
    }

    private static final IActionApi actionApi_delegate$lambda$0() {
        return (IActionApi)NetServiceGenerator.Companion.getInstance().getService(IActionApi.class);
    }

    public static final /* synthetic */ MutableLiveData access$getShareLiveData$p(ActionViewModel $this) {
        return $this.shareLiveData;
    }

    public static final /* synthetic */ MutableLiveData access$getLikeLiveData$p(ActionViewModel $this) {
        return $this.likeLiveData;
    }
}

