package com.transsion.share.api

import android.app.Application
import android.text.TextUtils
import androidx.lifecycle.AndroidViewModel
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import com.google.gson.JsonObject
import com.tn.lib.net.base.BaseObserver
import com.tn.lib.net.base.BaseScheduler
import com.tn.lib.net.env.Host
import com.tn.lib.net.manager.NetServiceGenerator
import com.transsion.share.bean.LikeEntity
import com.transsion.share.bean.ShareBean
import com.transsion.share.bean.ShareType
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.RequestBody.Companion.toRequestBody

class ActionViewModel (application: Application) : AndroidViewModel(application)  {


    private val TAG = "ActionViewModel"

    private val shareLiveData = MutableLiveData<ShareBean?>()
    private val likeLiveData = MutableLiveData<LikeEntity?>()


    private val actionApi by lazy { NetServiceGenerator.instance.getService(IActionApi::class.java) }

    fun getShareLiveData(): LiveData<ShareBean?> {
        return shareLiveData
    }

    fun getLikeLiveData(): LiveData<LikeEntity?> {
        return likeLiveData
    }

    fun share(shareType: ShareType, postType: String, subjectId: String, uid:String, scene:String) {
        if (TextUtils.isEmpty(subjectId)) return
        val json = JsonObject()
        json.addProperty("uid", uid)
        json.addProperty("type",postType)
        json.addProperty("scene", scene)
        json.addProperty("id", subjectId)
        var body = json.toString().toRequestBody("application/json".toMediaTypeOrNull())
        actionApi.subjectShare(Host.getHost(), body)
            .compose(BaseScheduler.compose())
            .subscribe(object : BaseObserver<ShareBean>() {
                override fun onFailure(code: String?, message: String?) {
                    shareLiveData.value = null
                }

                override fun onSuccess(data: ShareBean?) {
                    data?.shareType = shareType
                    shareLiveData.value = data
                }

            })
    }

    fun like(postId: String, like: Boolean) {
        if (TextUtils.isEmpty(postId)) return
        var json = JsonObject()
        json.addProperty("postId", postId)
        if(like){
            json.addProperty("reqType",0)//like
        }else{
            json.addProperty("reqType", 1)//cancel
        }
        var body = json.toString().toRequestBody("application/json".toMediaTypeOrNull())
        actionApi.like(Host.getHost(), body)
            .compose(BaseScheduler.compose())
            .subscribe(object : BaseObserver<LikeEntity>() {
                override fun onFailure(code: String?, message: String?) {
                    likeLiveData.value = null
                }

                override fun onSuccess(data: LikeEntity?) {
                    likeLiveData.value = data
                }
            })
    }


}