package com.transsion.share.share

import android.Manifest
import android.app.Activity
import android.content.ActivityNotFoundException
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager
import android.net.Uri
import android.os.Build
import androidx.appcompat.app.AlertDialog
import com.transsion.share.R

object ShareTools {
    val STORAGE_PERMISSIONS =
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.TIRAMISU) {
            arrayOf(
                Manifest.permission.WRITE_EXTERNAL_STORAGE,
                Manifest.permission.READ_EXTERNAL_STORAGE
            )
        } else {
            arrayOf(
                Manifest.permission.READ_MEDIA_VIDEO
            )
        }


    const val DEFAULT_INTERVALS = 2000L
    private var lastClickTime: Long = 0
    private var lastClickViewId = 0

    fun isFastClick(id: Int, time: Long = DEFAULT_INTERVALS): Boolean {
        if (lastClickViewId != id) {
            lastClickViewId = id
            lastClickTime = System.currentTimeMillis()
            return false
        }
        val tmp: Long = System.currentTimeMillis() - lastClickTime
        if (tmp <= time) {
            return true
        }
        lastClickViewId = id
        lastClickTime = System.currentTimeMillis()
        return false
    }


    fun switchToSysSettingDetails(activity: Activity, requestCode: Int = 14) {
        val packageName: String = activity.packageName //Objects.requireNonNull(fragment.getContext()).getPackageName()
        val permission = Intent("com.android.setting.ACTION_GET_PERMISSION_DETAILS")
        permission.putExtra("packagename", packageName)
        permission.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
        try {
            if (requestCode > 0) {
                activity.startActivityForResult(permission, requestCode)
            } else {
                activity.startActivity(permission)
            }
        } catch (var8: ActivityNotFoundException) {
            try {
                val intent = Intent("android.settings.APPLICATION_DETAILS_SETTINGS")
                intent.data = Uri.parse("package:$packageName")
                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                if (requestCode > 0) {
                    activity.startActivityForResult(intent, requestCode)
                } else {
                    activity.startActivity(intent)
                }
            } catch (anf: ActivityNotFoundException) {
                try {
                    val intent = Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS")
                    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                    if (requestCode > 0) {
                        activity.startActivityForResult(intent, requestCode)
                    } else {
                        activity.startActivity(intent)
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    fun verifyGrantResults(grantResults: IntArray): Boolean {
        for (grantResult in grantResults) {
            if (grantResult == PackageManager.PERMISSION_DENIED) {
                return false
            }
        }
        return true
    }

    /* 展示确定弹窗 */
    fun showConfirmationDialog(context: Context, title: String, message: String, onConfirm: () -> Unit) {
        // 创建 AlertDialog.Builder
        val builder = AlertDialog.Builder(context)

        // 设置标题
        builder.setTitle(title)

        // 设置消息
        builder.setMessage(message)

        // 设置“确定”按钮及其点击事件
        builder.setPositiveButton(context.getString(R.string.system_settings)) { dialog, _ ->
            onConfirm() // 调用确认回调
            dialog.dismiss() // 关闭弹窗
        }

        // 设置“取消”按钮及其点击事件（可选）
        builder.setNegativeButton(context.getString(R.string.cancel)) { dialog, _ ->
            dialog.dismiss() // 关闭弹窗
        }

        // 创建并显示弹窗
        val dialog = builder.create()
        dialog.show()
    }
}