package com.transsion.share

import android.content.Context
import com.transsion.share.share.ShareItemCallback


/**
 * @author: zhiwei.chen
 * @date: 2025/4/9
 * @description: 分享初始化
 */
object ShareInit {
    private var appName: String = ""
    private var userId: (() -> String?)? = null
    private var reportShow: ((
        context:Context,
        reportType: String?, id: String,
        shareItemCallback: ShareItemCallback?
    ) -> Unit)? = null
    private var toastShow: ((String) -> Unit)? = null

    open fun init(
        appName: String, userId: () -> String?,
        reportShow: (
            context:Context,
            reportType: String?, id: String,
            shareItemCallback: ShareItemCallback?
        ) -> Unit,
        toastShow: (String) -> Unit
    ) {
        this.appName = appName
        this.userId = userId
        this.reportShow = reportShow
        this.toastShow = toastShow
    }


    /* 获取app name */
    internal fun getAppName(): String {
        return appName
    }

    /* 获取用户id */
    internal fun getUserId(): String {
        return userId?.invoke() ?: ""
    }

    /* 举报展示 */
    internal fun reportShow(
        context:Context,
        reportType: String?, id: String,
        shareItemCallback: ShareItemCallback? = null
    ) {
        reportShow?.invoke(context, reportType, id, shareItemCallback)
    }

    /* toast展示 */
    internal fun toast(content: String) {
        toastShow?.invoke(content)
    }
}