package com.transsion.share.share

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.annotation.Nullable
import androidx.recyclerview.widget.RecyclerView
import com.blankj.utilcode.util.ScreenUtils
import com.blankj.utilcode.util.SizeUtils
import com.transsion.share.R
import com.transsion.share.bean.ShareData

class ShareAdapter(private var mDatas: List<ShareData>) : RecyclerView.Adapter<ShareAdapter.ViewHolder>(){

    private var mOnItemClickListener: OnItemClickListener? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view = LayoutInflater.from(parent.context).inflate(R.layout.adapter_share, parent,  false)
        return ViewHolder(view)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val lp = holder.itemView.layoutParams as RecyclerView.LayoutParams
        // 计算marginEnd 保证刚好显示4个半
        val marginEnd = (ScreenUtils.getScreenWidth() - SizeUtils.dp2px(4f * 60 + 30 + 16)) / 4
        when (position) {
            0 -> {    // 第一个与左边间距16dp
                lp.marginStart = SizeUtils.dp2px(16f)
                lp.marginEnd = marginEnd
            }
            itemCount - 1 -> {    // 最后一个与右边间距16dp
                lp.marginStart = 0
                lp.marginEnd = SizeUtils.dp2px(16f)
            }
            else -> {
                lp.marginStart = 0
                lp.marginEnd = marginEnd
            }
        }
        val item = mDatas[position]
        holder.tvShare.text = item.shareName
        holder.tvShare.setCompoundDrawablesRelativeWithIntrinsicBounds(0, item.shareIconId, 0, 0)
        holder.itemView.setOnClickListener {
            if (!ShareTools.isFastClick(it.hashCode()))  {
                mOnItemClickListener?.onItemClickListener(item)
            }
        }
    }

    override fun getItemCount(): Int {
        return mDatas.size
    }

    class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        var tvShare: TextView = itemView.findViewById(R.id.tv_share)
    }

    fun setOnItemClickListener(@Nullable onItemClickListener: OnItemClickListener) {
        mOnItemClickListener = onItemClickListener
    }

}