package com.transsion.share.share

import android.app.Activity
import android.content.ActivityNotFoundException
import android.content.Intent
import android.net.Uri

/**
 *   Transsion MI
 *   Created By Liupeng
 *   On 2023/5/23 18:25
 *
 *   Desc  分享工具类
 */
object ShareUtils {


    private val default_prefix="https://play.google.com/store/apps/details?id=com.community.oneroom"

    const val TELEGRAM_PACKAGE_NAME = "org.telegram.messenger"
    const val TELEGRAM_PACKAGE_NAME_X = "org.thunderdog.challegram"
    const val TWITTER_PACKAGE_NAME = "com.twitter.android"
    const val WHATSAPP_PACKAGE_NAME = "com.whatsapp"
    const val INSTAGRAM_PACKAGE_NAME = "com.instagram.android"

    const val TWITTER_ACTIVITY = "com.twitter.composer.ComposerActivity"




    fun shareToTelegram(activity: Activity, shareContent: String, callback: ((Boolean) -> Unit?)? = null) {
        val sendIntent = Intent()
        try {
            sendIntent.apply {
                action = Intent.ACTION_SEND
                putExtra(Intent.EXTRA_TEXT, shareContent)
                type = "text/plain"
                `package` =  TELEGRAM_PACKAGE_NAME
            }
            activity.startActivity(sendIntent)
            callback?.invoke(true)
        } catch (e: ActivityNotFoundException) {
            try {
                sendIntent.`package` = TELEGRAM_PACKAGE_NAME_X
                activity.startActivity(sendIntent)
                callback?.invoke(true)
            }catch (e: Exception){
                callback?.invoke(false)
            }
        }
    }

    /**
     * 分享图片 到Telegram
     */
    fun shareImageToTelegram(
        activity: Activity,
        imageUri: Uri?,
        callback: ((Boolean) -> Unit?)? = null
    ) {
        val sendIntent = Intent(Intent.ACTION_SEND).apply {
            setType("image/*")
            putExtra(Intent.EXTRA_STREAM, imageUri)
        }
        // 开始分享
        try {
            sendIntent.apply {
                `package` = TELEGRAM_PACKAGE_NAME
            }
            activity.startActivity(sendIntent)
            callback?.invoke(true)
        } catch (e: ActivityNotFoundException) {
            try {
                sendIntent.`package` = TELEGRAM_PACKAGE_NAME_X
                activity.startActivity(sendIntent)
                callback?.invoke(true)
            } catch (e: Exception) {
                callback?.invoke(false)
            }
        }
    }

    /**
     * 分享图片 到第三方应用  https://developer.android.com/training/sharing/send?hl=zh-cn
     **/
    fun shareImage(
        activity: Activity,
        packageName: String?,
        imageUri: Uri?,
        callback: ((Boolean) -> Unit?)? = null
    ) {
        try {
            if (packageName.isNullOrEmpty()) {
                callback?.invoke(false)
                return
            }
            activity.startActivity(Intent(Intent.ACTION_SEND).apply {
                setType("image/*")
                putExtra(Intent.EXTRA_STREAM, imageUri)
                setPackage(packageName)
            })
            callback?.invoke(true)
        } catch (e: Exception) {
            callback?.invoke(false)
        }
    }


    fun shareToWhatsapp(activity: Activity, shareContent: String, callback: ((Boolean) -> Unit?)? = null) {
        try {

            val sendIntent = Intent().apply {
                /** https://faq.whatsapp.com/425247423114725/?helpref=search&cms_platform=iphone&locale=zh_CN
                 * 反编译 whatsapp所得
                 *  <action android:name="android.intent.action.VIEW"/>
                 *                 <action android:name="com.whatsapp.DEEP_LINK_REDIRECT"/>
                 *                 <category android:name="android.intent.category.DEFAULT"/>
                 *                 <category android:name="android.intent.category.BROWSABLE"/>
                 *                 <data android:scheme="whatsapp" android:host="send"/>
                 */
                val uri = Uri.parse("whatsapp://send?text=${Uri.encode(shareContent)}")
                setAction(Intent.ACTION_VIEW)
                setData(uri)
            }
            activity.startActivity(sendIntent)
            callback?.invoke(true)
        } catch (e: Exception) {
            callback?.invoke(false)
        }
    }
}