package com.transsion.share.like

import android.animation.AnimatorSet
import android.content.Context
import android.content.res.Resources
import android.widget.TextView
import java.math.BigDecimal
import java.text.DecimalFormat

class LikeManager {

    companion object {

        const val TAG = "LikeManager"

       /* @JvmStatic
        val INSTANCE: LikeManager by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            LikeManager()
        }*/
    }

    var context: Context? = null
    private val df = DecimalFormat(",###,##0.#") //没有小数
    private var mAnimatorSet: AnimatorSet? = null
    private var likeTextView: TextView? = null
    private var likeNum: String = ""
   // private var likeAnimView: LottieAnimationView? = null




    //private constructor()


    /**
     * 点赞
     * likeAnimView 点赞view
     * likeTextView 点赞数量TextView
     * likeNum 点赞数量
     */
    /*fun startLike(
        context: Context,
        likeAnimView: LottieAnimationView,
        likeTextView: TextView?,
        likeNum: String
    ) {
        this.likeAnimView = likeAnimView
        this.likeNum = likeNum
        this.likeTextView = likeTextView
        likeAnimView?.playAnimation()
        likeAnimView?.removeCallbacks(likeRunnable)
        likeAnimView?.postDelayed(likeRunnable, 400)
    }*/


    /**
     * 初始化点赞动画状态
     */
  /*  fun resetLikeImg(context: Context, likeAnimView: LottieAnimationView,likeStatus:Boolean) {
        likeAnimView?.pauseAnimation()
        likeAnimView?.cancelAnimation()
        likeAnimView?.imageAssetsFolder = "images/"
        likeAnimView?.setAnimation("player_data_like.json")
        likeAnimView?.setPadding(0, 0, 0, 0)
        likeAnimView?.repeatCount = 0
        if (likeStatus) {
            likeAnimView?.progress = 1F
        } else {
            likeAnimView?.progress = 0F
        }
    }

    private var likeRunnable = Runnable {
        showLikeNumber(likeAnimView,likeTextView,likeNum)
    }*/

   /* @SuppressLint("ObjectAnimatorBinding", "SetTextI18n")
    private fun showLikeNumber(
        likeAnimView: LottieAnimationView?,
        likeNumber: TextView?,
        likeNum: String
    ) {
        likeNumber?.text = likeNum?.toLong()?.minus(1)
            ?.let { getDisplayCount(it).toString() } + "+1"
        likeNumber?.visibility = View.VISIBLE
        val transAnimator = ObjectAnimator.ofFloat(
            likeNumber, "translationY", 0f, -dp2px(25f).toFloat()
        )
        transAnimator.duration = 900
        val mFadeInObjectAnimator = ObjectAnimator.ofFloat(likeNumber, "alpha", 0f, 1f)
        mFadeInObjectAnimator.duration = 900
        val mFadeOutObjectAnimator = ObjectAnimator.ofFloat(likeNumber, "alpha", 1f, 0f)
        mFadeOutObjectAnimator.duration = 600
        mFadeOutObjectAnimator.startDelay = 1500
        mFadeOutObjectAnimator.addListener(object : Animator.AnimatorListener {
            override fun onAnimationStart(animation: Animator) {}
            override fun onAnimationEnd(animation: Animator) {
                likeAnimView?.isEnabled = true
                likeNumber?.visibility = View.GONE
            }

            override fun onAnimationCancel(animation: Animator) {
                likeAnimView?.isEnabled = true
                likeNumber?.visibility = View.GONE
            }

            override fun onAnimationRepeat(animation: Animator) {}
        }) //AnimatorSet是可以让几个动画组合在一起执行的类
        mAnimatorSet = AnimatorSet() //先淡入再淡出
        mAnimatorSet?.play(mFadeInObjectAnimator)?.with(transAnimator)
            ?.before(mFadeOutObjectAnimator)
        mAnimatorSet?.start()
    }*/

    fun dp2px(dpValue: Float): Int {
        val scale = Resources.getSystem().displayMetrics.density
        return (dpValue * scale + 0.5f).toInt()
    }

    fun getDisplayCount(count: Long): String? {
        if (count < 0) {
            return "-"
        } //        long mills = System.currentTimeMillis();
        val result: String = try {
            if (count < 10000) {
                count.toString()
            } else if (count < 1000000) {
                val cout = count / 1000.0 //                BigDecimal a = new BigDecimal(cout);
                df.format(cout) + "K"
            } else if (count < 1000000000) {
                val cout = count / 1000000.0 //                BigDecimal a = new BigDecimal(cout);
                df.format(cout) + "M"
            } else if (count < 1000000000000L) {
                val cout =
                    count / 1000000000.0 //                BigDecimal a = new BigDecimal(cout);
                df.format(cout) + "B"
            } else {
                val cout = count / 1000000000000.0
                val a = BigDecimal(cout)
                df.format(a) + "T"
            }
        } catch (e: Exception) {
            "0"
        } //        GlobalConfig.tracePerform(mills);
        return result
    }

    private fun destroy(){
        mAnimatorSet?.cancel()
        //likeAnimView?.removeCallbacks(likeRunnable)
    }

}