/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.subtitle_download.task;

import android.app.Application;
import android.content.Context;
import android.os.Environment;
import com.blankj.utilcode.util.Utils;
import com.transsion.subtitle_download.SubtitleDownloadManager;
import com.transsion.subtitle_download.db.SubtitleDownloadDatabase;
import com.transsion.subtitle_download.db.SubtitleDownloadTable;
import com.transsion.subtitle_download.utils.Logger;
import com.transsion.subtitle_download.utils.SubtitleUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ&\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH&J\u001a\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013JY\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2!\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00070\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016\u00a8\u0006!"}, d2={"Lcom/transsion/subtitle_download/task/BaseSubtitleDownloadTask;", "", "<init>", "()V", "getClassTag", "", "download", "", "dbBean", "Lcom/transsion/subtitle_download/db/SubtitleDownloadTable;", "callback", "Lkotlin/Function0;", "disposeOnChangeUrl", "response", "Lokhttp3/Response;", "disposeOnResponse", "disposeOnFailure", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "disposeOutputStream", "", "destination", "length", "", "progressCallback", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "progress", "completeCallback", "Companion", "SubtitleDownload_release"})
@SourceDebugExtension(value={"SMAP\nBaseSubtitleDownloadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseSubtitleDownloadTask.kt\ncom/transsion/subtitle_download/task/BaseSubtitleDownloadTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,227:1\n1#2:228\n*E\n"})
public abstract class BaseSubtitleDownloadTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SUBTITLE_DOWNLOAD_FILE_PATH;
    @NotNull
    private static final String SUBTITLE_DOWNLOAD_ZIP_FILE_PATH;
    @NotNull
    private static final Lazy<OkHttpClient> client$delegate;

    @NotNull
    public final String getClassTag() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    public final void download(@NotNull SubtitleDownloadTable dbBean, @NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)dbBean, (String)"dbBean");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Logger.INSTANCE.logD(this.getClassTag() + " --> download() --> \u5b57\u5e55\u4e0b\u8f7d --> \u5f00\u59cb\u6267\u884c\u4e0b\u8f7d\u4efb\u52a1\u4e86 --> getSubtitleInfo = " + dbBean.getSubtitleInfo());
        Logger.INSTANCE.logD("\u5f00\u59cb\u6267\u884c\u4e0b\u8f7d\u4efb\u52a1\u4e86 --> url = " + dbBean.getUrl());
        Request.Builder builder = new Request.Builder();
        String string = dbBean.getUrl();
        if (string == null) {
            string = "";
        }
        Request request = builder.url(string).build();
        BaseSubtitleDownloadTask.Companion.getClient().newCall(request).enqueue(new Callback(this, dbBean, callback){
            final /* synthetic */ BaseSubtitleDownloadTask this$0;
            final /* synthetic */ SubtitleDownloadTable $dbBean;
            final /* synthetic */ Function0<Unit> $callback;
            {
                this.this$0 = $receiver;
                this.$dbBean = $dbBean;
                this.$callback = $callback;
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.disposeOnFailure(this.$dbBean, new RuntimeException(e.getMessage()));
                this.$callback.invoke();
            }

            /*
             * Enabled aggressive block sorting
             */
            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (response.isSuccessful()) {
                    this.this$0.disposeOnResponse(response, this.$dbBean);
                    this.$callback.invoke();
                    return;
                }
                if (response.code() != 404) {
                    int n = response.code();
                    boolean bl = 400 <= n ? n < 600 : false;
                    if (bl) {
                        BaseSubtitleDownloadTask.access$disposeOnChangeUrl(this.this$0, response, this.$dbBean, this.$callback);
                        return;
                    }
                }
                this.this$0.disposeOnFailure(this.$dbBean, new RuntimeException(response.message()));
                this.$callback.invoke();
            }
        });
    }

    private final void disposeOnChangeUrl(Response response, SubtitleDownloadTable dbBean, Function0<Unit> callback) {
        this.disposeOnFailure(dbBean, new RuntimeException(response.message()));
        callback.invoke();
    }

    public abstract void disposeOnResponse(@NotNull Response var1, @NotNull SubtitleDownloadTable var2);

    public final void disposeOnFailure(@NotNull SubtitleDownloadTable dbBean, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)dbBean, (String)"dbBean");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        dbBean.setFailCount(dbBean.getFailCount() + 1);
        Logger.INSTANCE.logE(this.getClassTag() + " --> disposeOnFailure() --> e = " + e.getMessage() + " -- getSubtitleInfo = " + dbBean.getSubtitleInfo() + " --> dbBean.failCount = " + dbBean.getFailCount());
        dbBean.setStatus(6);
        if (dbBean.getType() == 2 || dbBean.getType() == 4 || dbBean.getType() == 5 || dbBean.getFailCount() > 5) {
            Logger.INSTANCE.logE(this.getClassTag() + " --> disposeOnFailure() --> delete(dbBean) --> \u5982\u679c\u662f\u641c\u7d22\u5b57\u5e55\uff0c\u4e0b\u8f7d\u5931\u8d25\u5c31\u4ece\u6570\u636e\u5e93\u79fb\u9664 --> getSubtitleInfo = " + dbBean.getSubtitleInfo() + " --> failCount = " + dbBean.getFailCount());
            Application application = Utils.getApp();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
            SubtitleDownloadDatabase.Companion.getInstance$SubtitleDownload_release((Context)application).subtitleDownloadDao().delete(dbBean);
        } else {
            Application application = Utils.getApp();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
            SubtitleDownloadDatabase.Companion.getInstance$SubtitleDownload_release((Context)application).subtitleDownloadDao().update(dbBean);
        }
        SubtitleDownloadManager.INSTANCE.notifyDownloadFail$SubtitleDownload_release(e, dbBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disposeOutputStream(@NotNull Response response, @NotNull String destination, long length, @NotNull SubtitleDownloadTable dbBean, @NotNull Function1<? super Integer, Unit> progressCallback, @NotNull Function0<Unit> completeCallback) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)dbBean, (String)"dbBean");
        Intrinsics.checkNotNullParameter(progressCallback, (String)"progressCallback");
        Intrinsics.checkNotNullParameter(completeCallback, (String)"completeCallback");
        if (length <= 0L && !dbBean.isOpenSbNewApi()) {
            this.disposeOnFailure(dbBean, new RuntimeException(this.getClassTag() + " --> disposeOutputStream --> length <= 0 --> length = " + length));
            return false;
        }
        SubtitleUtils.INSTANCE.createDirectoryIfNotExists(SUBTITLE_DOWNLOAD_FILE_PATH);
        SubtitleUtils.INSTANCE.createDirectoryIfNotExists(SUBTITLE_DOWNLOAD_ZIP_FILE_PATH);
        try {
            ResponseBody responseBody = response.body();
            Closeable closeable = responseBody != null ? responseBody.byteStream() : null;
            Throwable throwable = null;
            try {
                InputStream byteStream = (InputStream)closeable;
                boolean bl2 = false;
                Closeable closeable2 = new FileOutputStream(destination);
                Throwable throwable2 = null;
                try {
                    FileOutputStream fos = (FileOutputStream)closeable2;
                    boolean bl3 = false;
                    byte[] buf = new byte[102400];
                    int sum = 0;
                    int len = 0;
                    dbBean.setStatus(2);
                    while (true) {
                        boolean bl4;
                        InputStream inputStream = byteStream;
                        if (inputStream != null) {
                            int n;
                            int it = n = inputStream.read(buf);
                            boolean bl5 = false;
                            len = it;
                            bl4 = n == -1;
                        } else {
                            bl4 = false;
                        }
                        if (bl4) break;
                        fos.write(buf, 0, len);
                        int progress = (int)((float)(sum += len) * 1.0f / (float)length * (float)100);
                        progressCallback.invoke((Object)progress);
                        if (progress < 100) continue;
                        completeCallback.invoke();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            bl = true;
        }
        catch (Exception e) {
            this.disposeOnFailure(dbBean, new RuntimeException(this.getClassTag() + " --> disposeOutputStream --> \u5b57\u5e55\u4e0b\u8f7d\u51fa\u95ee\u9898\u4e86,e = " + e.getMessage()));
            bl = false;
        }
        return bl;
    }

    private static final OkHttpClient client_delegate$lambda$3() {
        return new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).cache(null).build();
    }

    public static final /* synthetic */ void access$disposeOnChangeUrl(BaseSubtitleDownloadTask $this, Response response, SubtitleDownloadTable dbBean, Function0 callback) {
        $this.disposeOnChangeUrl(response, dbBean, (Function0<Unit>)callback);
    }

    static {
        File file = Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS);
        SUBTITLE_DOWNLOAD_FILE_PATH = (file != null ? file.getAbsolutePath() : null) + File.separatorChar + "subtitle";
        file = Utils.getApp().getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS);
        SUBTITLE_DOWNLOAD_ZIP_FILE_PATH = (file != null ? file.getAbsolutePath() : null) + File.separatorChar + "subtitle_zip";
        client$delegate = LazyKt.lazy(BaseSubtitleDownloadTask::client_delegate$lambda$3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/transsion/subtitle_download/task/BaseSubtitleDownloadTask$Companion;", "", "<init>", "()V", "SUBTITLE_DOWNLOAD_FILE_PATH", "", "getSUBTITLE_DOWNLOAD_FILE_PATH", "()Ljava/lang/String;", "SUBTITLE_DOWNLOAD_ZIP_FILE_PATH", "getSUBTITLE_DOWNLOAD_ZIP_FILE_PATH", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "SubtitleDownload_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSUBTITLE_DOWNLOAD_FILE_PATH() {
            return SUBTITLE_DOWNLOAD_FILE_PATH;
        }

        @NotNull
        public final String getSUBTITLE_DOWNLOAD_ZIP_FILE_PATH() {
            return SUBTITLE_DOWNLOAD_ZIP_FILE_PATH;
        }

        private final OkHttpClient getClient() {
            Lazy lazy = client$delegate;
            return (OkHttpClient)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

