package com.transsion.subtitle_download.api

import com.transsion.subtitle_download.bean.SubtitleListBean
import com.tn.lib.net.bean.BaseDto
import com.tn.lib.net.cons.NetConst
import retrofit2.http.GET
import retrofit2.http.Query

/**
 * @author: zhangxinbing
 * @date : 2024/5/13 16:37
 * @description: 资源字幕请求
 */
internal interface SubtitleDownloadApi {

    /**
     * 获取字幕下载列表
     */
    @GET("/wefeed-mobile-bff/subject-api/get-ext-captions")
    suspend fun getSubtitles(
        @Query(NetConst.HOST) host: String,
        @Query("subjectId") subjectId: String?,
        @Query("resourceId") resourceId: String?,
        @Query("episode") episode: Int = 0
    ): BaseDto<SubtitleListBean>

    /**
     * 获取字幕下载列表
     */
    @GET("/wefeed-mobile-bff/subject-api/get-stream-captions")
    suspend fun getStreamSubtitles(
        @Query(NetConst.HOST) host: String,
        @Query("subjectId") subjectId: String?,
        @Query("streamId") resourceId: String?
    ): BaseDto<SubtitleListBean>

    /**
     * 获取短剧字幕下载列表
     */
    @GET("/wefeed-mobile-bff/shorts/get-mini-captions")
    suspend fun getMbShortTVSubtitles(
        @Query(NetConst.HOST) host: String,
        @Query("miniId") miniId: String?,
    ): BaseDto<SubtitleListBean>


    /**
     * 获取短剧字幕下载列表
     */
    @GET("/wefeed-short-bff/shorts/get-mini-captions")
    suspend fun getNovelShortTVSubtitles(
        @Query(NetConst.HOST) host: String,
        @Query("miniId") miniId: String?,
    ): BaseDto<SubtitleListBean>


}