package com.transsion.subtitle_download.bean

import android.os.Parcelable
import androidx.annotation.Keep
import com.google.gson.annotations.SerializedName
import kotlinx.parcelize.Parcelize
import java.io.Serializable

/**
 * @author: zhangxinbing
 * @date : 2024/5/13 16:34
 * @description: 字幕接口Bean
 */
@Keep
@Parcelize
data class SubtitleItem(
    var id: String?,//资源id，该资源唯一标识
    @SerializedName(
        value = "lan", alternate = ["shortLanguage"]
    ) var lan: String?,//字幕语言缩写，跟手机里获取的语音缩写一一对应
    @SerializedName(value = "lanName", alternate = ["language"]) var lanName: String?,//字幕语言翻译后的名称
    var name: String?,//字幕名称，来自搜索
    var url: String?,//下载链接
    var size: Long?,//资源大小
    var delay: Long?,//字幕校准时长
    var season: Int?,//电视剧季数 电影则为0
    var episode: Int?,//电视剧集数 电影则为0
    var downloads: Int?,//下载数
    var type: Int?,//来源？ 对应SubtitleBean type
) : Parcelable, Serializable{
    val lanAbbr: String?
        get() = if (lan == "in_id") "in" else lan
}
