package com.transsion.subtitle_download.bean

import androidx.annotation.IntDef
import com.transsion.subtitle_download.bean.SubtitleStatus.Companion.STATUS_COMPLETED
import com.transsion.subtitle_download.bean.SubtitleStatus.Companion.STATUS_LOADING
import com.transsion.subtitle_download.bean.SubtitleStatus.Companion.STATUS_ERROR
import com.transsion.subtitle_download.bean.SubtitleStatus.Companion.STATUS_NONE

/**
 * @author: zhangxinbing
 * @date : 2024/5/13 17:06
 * @description: 字幕的本地状态
 */
@IntDef(
    STATUS_NONE, STATUS_COMPLETED, STATUS_LOADING, STATUS_ERROR
)
@Retention(AnnotationRetention.SOURCE)
annotation class SubtitleStatus {
    companion object {
        // 1-error
        //2-下载完成
        //3-下载中
        const val STATUS_NONE = 0 // 初始值
        const val STATUS_COMPLETED = 5 // 下载成功
        const val STATUS_LOADING = 2 // 下载中
        const val STATUS_ERROR = 6 // 下载失败
    }
}