package com.transsion.subtitle_download.bean

import com.transsion.subtitle_download.bean.SubtitleStatus.Companion.STATUS_NONE
import com.transsion.subtitle_download.db.SubtitleDownloadTable

/**
 * @author: zhangxinbing
 * @date : 2024/5/13 19:31
 * @description: bean 类型转化
 */
internal object TransformBeanType {

    /**
     * 网络类型转换成数据库类型
     */
    fun transformSubtitle2DbBean(
        subjectId: String?, resourceId: String?, subjectName: String?, @SubResStreamType resStreamType: Int,
        ep: Int = 0,//集
        se: Int = 0,//季
        subtitleItem: SubtitleItem
    ): SubtitleDownloadTable {
        return subtitleDownloadTable(subtitleItem, resourceId, subjectId, subjectName, resStreamType, ep, se)
    }

    fun transformSubtitle2DbBeanList(
        subjectId: String?, resourceId: String?, subjectName: String?, @SubResStreamType resStreamType: Int,
        ep: Int = 0,//集
        se: Int = 0,//季
        subtitleItems: List<SubtitleItem>
    ): MutableList<SubtitleDownloadTable> {
        val list = mutableListOf<SubtitleDownloadTable>()
        subtitleItems.forEach {
            list.add(
                subtitleDownloadTable(it, resourceId, subjectId, subjectName, resStreamType, ep, se)
            )
        }
        return list
    }

    /**
     * TODO 这里需要新检查一下
     */
    private fun subtitleDownloadTable(
        it: SubtitleItem, resourceId: String?, subjectId: String?, subjectName: String?, @SubResStreamType resStreamType: Int,
        ep: Int = 0,//集
        se: Int = 0,//季
    ) = SubtitleDownloadTable(
        id = it.id ?: "",
        lan = it.lan,
        lanName = it.lanName,
        subtitleName = it.name,
        url = it.url,
        size = it.size,
        delay = it.delay,
        downloads = it.downloads,
        type = it.type ?: SubtitleType.TYPE_INNER, // 到这里都是API对应的字段

        // 下面是自定义字段
        resourceId = resourceId ?: "",
        postId = "",
        subjectId = subjectId,
        ep = it.episode ?: ep,
        se = it.season ?: se,
        resolution = 0,
        subjectName = subjectName,
        resourceStreamType = resStreamType,
        status = STATUS_NONE,
        path = ""
    )


}