/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.subtitle_download.task;

import android.app.Application;
import android.content.Context;
import com.blankj.utilcode.util.Utils;
import com.transsion.subtitle_download.SubtitleDownloadManager;
import com.transsion.subtitle_download.db.SubtitleDownloadDatabase;
import com.transsion.subtitle_download.db.SubtitleDownloadTable;
import com.transsion.subtitle_download.task.BaseSubtitleDownloadTask;
import com.transsion.subtitle_download.utils.Logger;
import com.transsion.subtitle_download.utils.SubtitleUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/transsion/subtitle_download/task/InStationSubtitleDownloadTask;", "Lcom/transsion/subtitle_download/task/BaseSubtitleDownloadTask;", "<init>", "()V", "disposeOnResponse", "", "response", "Lokhttp3/Response;", "dbBean", "Lcom/transsion/subtitle_download/db/SubtitleDownloadTable;", "SubtitleDownload_release"})
public final class InStationSubtitleDownloadTask
extends BaseSubtitleDownloadTask {
    @Override
    public void disposeOnResponse(@NotNull Response response, @NotNull SubtitleDownloadTable dbBean) {
        String string;
        long length;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)dbBean, (String)"dbBean");
        ResponseBody responseBody = response.body();
        long l = length = responseBody != null ? responseBody.contentLength() : 0L;
        if (response.body() == null) {
            Logger.INSTANCE.logE(this.getClassTag() + " --> disposeOnResponse() --> null == response.body --> headers = " + response.headers());
        }
        String fileType = String.valueOf((string = dbBean.getUrl()) != null && (string = StringsKt.substringBefore$default((String)string, (String)"?", null, (int)2, null)) != null ? StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null) : null);
        String filename = dbBean.getEp() > 0 ? dbBean.getSubjectFileName() + "_S" + dbBean.getSe() + "_E" + dbBean.getEp() + "_" + dbBean.getLanName() + "." + fileType : dbBean.getSubjectFileName() + "_" + dbBean.getLanName() + "." + fileType;
        String filePath = dbBean.getEp() > 0 ? BaseSubtitleDownloadTask.Companion.getSUBTITLE_DOWNLOAD_FILE_PATH() + File.separatorChar + dbBean.getSubjectFileName() + "_S" + dbBean.getSe() + "_E" + dbBean.getEp() : BaseSubtitleDownloadTask.Companion.getSUBTITLE_DOWNLOAD_FILE_PATH() + File.separatorChar + dbBean.getSubjectFileName();
        SubtitleUtils.INSTANCE.createDirectoryIfNotExists(filePath);
        String destination = filePath + File.separatorChar + filename;
        Logger.INSTANCE.logD(this.getClassTag() + " --> disposeOnResponse() --> \u63a5\u53e3\u8bf7\u6c42\u6210\u529f \u5f00\u59cb\u4fdd\u5b58\u6570\u636e\u5230\u672c --> " + dbBean.getName() + "." + dbBean.getResourceId() + ",\u6587\u4ef6\u5927\u5c0f = " + length + " --> destination = " + destination);
        this.disposeOutputStream(response, destination, length, dbBean, (Function1<? super Integer, Unit>)((Function1)arg_0 -> InStationSubtitleDownloadTask.disposeOnResponse$lambda$0(dbBean, arg_0)), (Function0<Unit>)((Function0)() -> InStationSubtitleDownloadTask.disposeOnResponse$lambda$1(dbBean, destination, this)));
    }

    private static final Unit disposeOnResponse$lambda$0(SubtitleDownloadTable $dbBean, int it) {
        SubtitleDownloadManager.INSTANCE.notifyDownloadProgress$SubtitleDownload_release(it, $dbBean);
        return Unit.INSTANCE;
    }

    private static final Unit disposeOnResponse$lambda$1(SubtitleDownloadTable $dbBean, String $destination, InStationSubtitleDownloadTask this$0) {
        $dbBean.setPath($destination);
        SubtitleUtils.INSTANCE.parseFileCharsetName($dbBean);
        $dbBean.setStatus(5);
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
        SubtitleDownloadDatabase.Companion.getInstance$SubtitleDownload_release((Context)application).subtitleDownloadDao().update($dbBean);
        Logger.INSTANCE.logD(this$0.getClassTag() + " --> disposeOnResponse() --> \u6587\u4ef6\u4fdd\u5b58\u5728 = " + $destination + " -- resourceId = " + $dbBean.getResourceId() + " --> getSubtitleInfo = " + $dbBean.getSubtitleInfo());
        SubtitleDownloadManager.INSTANCE.notifyDownloadComplete$SubtitleDownload_release($dbBean);
        return Unit.INSTANCE;
    }
}

