/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.subtitle_download.utils;

import android.util.Log;
import com.transsion.subtitle_download.utils.Logger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/transsion/subtitle_download/utils/GzipUti;", "", "<init>", "()V", "BUFF_SIZE", "", "unGzip", "", "zipFilePath", "", "destFilePath", "SubtitleDownload_release"})
@SourceDebugExtension(value={"SMAP\nGzipUti.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GzipUti.kt\ncom/transsion/subtitle_download/utils/GzipUti\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class GzipUti {
    @NotNull
    public static final GzipUti INSTANCE = new GzipUti();
    private static final int BUFF_SIZE = 1024;

    private GzipUti() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean unGzip(@NotNull String zipFilePath, @NotNull String destFilePath) {
        Intrinsics.checkNotNullParameter((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkNotNullParameter((Object)destFilePath, (String)"destFilePath");
        byte[] buffer = new byte[1024];
        int len = 0;
        FileOutputStream fos = null;
        FileInputStream fis = null;
        GZIPInputStream ungzip = null;
        boolean result = false;
        try {
            fos = new FileOutputStream(destFilePath);
            fis = new FileInputStream(zipFilePath);
            ungzip = new GZIPInputStream(fis);
            while (true) {
                int n;
                int it = n = ungzip.read(buffer);
                boolean bl = false;
                len = it;
                if (n == -1) break;
                fos.write(buffer, 0, len);
            }
            result = true;
        }
        catch (Throwable e) {
            try {
                result = false;
                Logger.INSTANCE.logE("GzipUti --> unGzip() --> " + Log.getStackTraceString((Throwable)e));
                return result;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    GZIPInputStream gZIPInputStream = ungzip;
                    if (gZIPInputStream != null) {
                        gZIPInputStream.close();
                    }
                    FileOutputStream fileOutputStream = fos;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    FileInputStream fileInputStream = fis;
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                }
            }
        }
        try {
            ungzip.close();
            fos.close();
            fis.close();
            return result;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return result;
        }
    }
}

