/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.subtitle_download.utils;

import android.os.Build;
import com.blankj.utilcode.util.FileIOUtils;
import com.blankj.utilcode.util.Utils;
import com.tn.lib.util.md5.MD5;
import com.transsion.subtitle_download.SubtitleDownloadManager;
import com.transsion.subtitle_download.db.SubtitleDownloadTable;
import com.transsion.subtitle_download.utils.Logger;
import ir.ac.iust.htmlchardet.HTMLCharsetDetector;
import java.io.File;
import java.util.Locale;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lcom/transsion/subtitle_download/utils/SubtitleUtils;", "", "<init>", "()V", "getClassTag", "", "getSystemLanguage", "getLanguageEn", "createDirectoryIfNotExists", "", "directoryPath", "deleteFile", "path", "getSearchSubtitleId", "url", "parseFileCharsetName", "", "subtitleBean", "Lcom/transsion/subtitle_download/db/SubtitleDownloadTable;", "isFileExist", "filePath", "getTaskId", "generateRandomString", "length", "", "SubtitleDownload_release"})
public final class SubtitleUtils {
    @NotNull
    public static final SubtitleUtils INSTANCE = new SubtitleUtils();

    private SubtitleUtils() {
    }

    private final String getClassTag() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String getSystemLanguage() {
        try {
            $i$a$-runCatching-SubtitleUtils$getSystemLanguage$1 = false;
            savedLanguage = SubtitleDownloadManager.INSTANCE.getAppLanguageName();
            v0 = locale = Build.VERSION.SDK_INT >= 24 ? Utils.getApp().getResources().getConfiguration().getLocales().get(0) : Utils.getApp().getResources().getConfiguration().locale;
            if (Intrinsics.areEqual((Object)locale.getLanguage(), (Object)savedLanguage)) ** GOTO lbl-1000
            v1 = savedLanguage;
            v2 = v1 != null ? ((CharSequence)v1).length() > 0 : false;
            if (v2) {
                v3 = new Locale(savedLanguage, locale.getCountry()).getLanguage();
            } else lbl-1000:
            // 2 sources

            {
                v3 = locale.getLanguage();
            }
            var1_2 = Result.constructor-impl((Object)v3);
        }
        catch (Throwable savedLanguage) {
            var1_2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)savedLanguage));
        }
        v4 = Result.exceptionOrNull-impl((Object)var1_2);
        if (v4 == null) {
            v5 = var1_2;
        } else {
            it = v4;
            $i$a$-getOrElse-SubtitleUtils$getSystemLanguage$2 = false;
            v5 = "";
        }
        return (String)v5;
    }

    @NotNull
    public final String getLanguageEn() {
        return "en";
    }

    public final void createDirectoryIfNotExists(@NotNull String directoryPath) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public final void deleteFile(@Nullable String path) {
        Object object;
        try {
            boolean delete;
            File file;
            boolean bl = false;
            String string = path;
            if (string == null) {
                string = "";
            }
            String msg = (file = new File(string)).exists() ? ((delete = file.delete()) ? "\u6587\u4ef6\u5220\u9664\u6210\u529f" : "\u6587\u4ef6\u5220\u9664\u5931\u8d25") : "\u6587\u4ef6\u4e0d\u5b58\u5728";
            Logger.INSTANCE.logD(INSTANCE.getClassTag() + " --> deleteFile() --> " + msg + " --> path = " + path);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable file) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)file));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            Logger.INSTANCE.logE(INSTANCE.getClassTag() + " --> deleteFile() --> \u5220\u9664\u6587\u4ef6\u53d1\u751f\u5f02\u5e38 --> it = " + it);
        }
    }

    @NotNull
    public final String getSearchSubtitleId(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return MD5.Companion.MD5Encode(url);
    }

    public final boolean parseFileCharsetName(@NotNull SubtitleDownloadTable subtitleBean) {
        boolean bl;
        File file;
        Intrinsics.checkNotNullParameter((Object)subtitleBean, (String)"subtitleBean");
        String string = subtitleBean.getPath();
        if (string == null) {
            string = "";
        }
        if (!(file = new File(string)).exists()) {
            return false;
        }
        try {
            String string2 = subtitleBean.getPath();
            Intrinsics.checkNotNull((Object)string2);
            byte[] bytes = FileIOUtils.readFile2BytesByStream((String)string2);
            boolean[] blArray = new boolean[]{true};
            String fileCharsetName = HTMLCharsetDetector.detect(bytes, blArray);
            Logger.INSTANCE.logD(this.getClassTag() + " --> parseFileCharsetName() --> fileCharsetName = " + fileCharsetName);
            Intrinsics.checkNotNull((Object)fileCharsetName);
            if (((CharSequence)fileCharsetName).length() > 0) {
                subtitleBean.setFileCharsetName(fileCharsetName);
            }
            bl = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public final boolean isFileExist(@Nullable String filePath) {
        boolean bl;
        String string = filePath;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            File file = new File(it);
            bl = file.exists();
        } else {
            SubtitleUtils $this$isFileExist_u24lambda_u245 = this;
            boolean bl3 = false;
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String getTaskId() {
        String str = System.currentTimeMillis() + this.generateRandomString(10);
        return MD5.Companion.MD5Encode(str);
    }

    @NotNull
    public final String generateRandomString(int length) {
        StringBuilder stringBuilder;
        Random random = new Random();
        String charSet = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder $this$generateRandomString_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        while (n < length) {
            int it = n++;
            boolean bl2 = false;
            int randomIndex = random.nextInt(charSet.length());
            $this$generateRandomString_u24lambda_u247.append(charSet.charAt(randomIndex));
        }
        return stringBuilder.toString();
    }
}

