package com.transsion.subtitle_download.bean

import androidx.annotation.IntDef

/**
 * @author: zhangxinbing
 * @date : 2024/5/13 17:06
 * @description: 字幕的类型来源
 */
@IntDef(
    SubtitleType.TYPE_INNER, SubtitleType.TYPE_SEARCH_INNER, SubtitleType.TYPE_LOCAL, SubtitleType.TYPE_SEARCH_OPEN_SUBTITLES, SubtitleType.TYPE_SEARCH_OPEN_SUBTITLES_NEW
)
@Retention(AnnotationRetention.SOURCE)
annotation class SubtitleType {
    companion object {
        const val TYPE_INNER = 1//内置下载的，固定几个小语种
        const val TYPE_SEARCH_INNER = 2//站内搜索
        const val TYPE_LOCAL = 3//本地导入的
        const val TYPE_SEARCH_OPEN_SUBTITLES = 4//openSubtitle搜索
        const val TYPE_SEARCH_OPEN_SUBTITLES_NEW = 5//openSubtitle搜索-新api
    }
}