package com.transsion.subtitle_download.db

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Update
import com.transsion.subtitle_download.bean.SubtitleStatus

/**
 * @author: zhangxinbing
 * @date : 2024/5/13 16:49
 * @description: 字幕数据库操作
 */
@Dao
interface SubtitleDownloadDao {

    /***插入信息*/
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insert(stDownloadTable: SubtitleDownloadTable)

    /***插入信息*/
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insert(stDownloadTableList: List<SubtitleDownloadTable>)


//    /***删除所有信息*/
//    @Query("DELETE FROM st_download_table")
//    suspend fun deleteAll()

    /***通过resourceID删除字幕信息*/
    @Query("DELETE FROM st_download_table WHERE resourceId =:resourceId")
    suspend fun deleteByResourceId(resourceId: String)

    /*** 条件删除*/
    @Delete
    fun delete(table: SubtitleDownloadTable)


    /***更新数据*/
    @Update
    fun update(stDownloadTable: SubtitleDownloadTable)


    /***获取所有信息*/
    @Query("SELECT * FROM st_download_table")
    suspend fun getAllSubtitleList(): List<SubtitleDownloadTable>

    /***获取所有下载失败的字幕*/
    @Query("SELECT * FROM st_download_table WHERE status = :status")
    suspend fun getDownloadFailureList(status: Int = SubtitleStatus.STATUS_ERROR): MutableList<SubtitleDownloadTable>?

    /***通过资源ID -- 条件查询*/
    @Query("SELECT * FROM st_download_table WHERE resourceId = :value")
    suspend fun getSubtitleList(value: String): MutableList<SubtitleDownloadTable>?

    /***通过字幕ID查询信息*/
    @Query("SELECT * FROM st_download_table WHERE id = :id AND resourceStreamType = :resourceStreamType")
    fun getSubtitleTableBean(id: String, resourceStreamType: Int): SubtitleDownloadTable?

}