package com.transsion.subtitle_download.task

import com.blankj.utilcode.util.Utils
import com.transsion.subtitle_download.SubtitleDownloadManager
import com.transsion.subtitle_download.bean.SubtitleStatus
import com.transsion.subtitle_download.db.SubtitleDownloadDatabase
import com.transsion.subtitle_download.db.SubtitleDownloadTable
import com.transsion.subtitle_download.utils.Logger
import com.transsion.subtitle_download.utils.SubtitleUtils
import okhttp3.Response
import java.io.File

/**
 * @author: zhangxinbing
 * @date : 2024/5/17 11:49
 * @description: 站内字幕下载 内置+搜索
 */
internal class InStationSubtitleDownloadTask : BaseSubtitleDownloadTask() {

    /**
     * 站内资源 处理下载成功响应
     */
    override fun disposeOnResponse(response: Response, dbBean: SubtitleDownloadTable) {
        // 请求成功 解析数据 -- 当前不在主线程
        //val mediaType = response.body?.contentType().toString()
        val length = response.body?.contentLength() ?: 0
        if (null == response.body) {
            Logger.logE("${getClassTag()} --> disposeOnResponse() --> null == response.body --> headers = ${response.headers}")
        }

        //val desc = String.format("文件类型为%s，文件大小为%d", mediaType, length)
        // url=https://clcdn.hakunaymatata.com/subtitle/e86ee4e8535777ada0b836b0e0c55802.srt?e=1716259362&h=8339f3239bd41c5636493bb15135dd66
        val fileType = "${dbBean.url?.substringBefore("?")?.substringAfterLast(".")}"
        // destination = /storage/emulated/0/Android/data/com.community.moviebox/files/Download/subtitle/8016432467647365920.srt

        val filename = if (dbBean.ep > 0) {
            "${dbBean.subjectFileName}_S${dbBean.se}_E${dbBean.ep}_${dbBean.lanName}.${fileType}"
        } else {
            "${dbBean.subjectFileName}_${dbBean.lanName}.${fileType}"
        }
        val filePath = if (dbBean.ep > 0) {
            SUBTITLE_DOWNLOAD_FILE_PATH + File.separatorChar + "${dbBean.subjectFileName}_S${dbBean.se}_E${dbBean.ep}"
        } else {
            SUBTITLE_DOWNLOAD_FILE_PATH + File.separatorChar + dbBean.subjectFileName
        }
        SubtitleUtils.createDirectoryIfNotExists(filePath)
        val destination = filePath + File.separatorChar + filename
        Logger.logD("${getClassTag()} --> disposeOnResponse() --> 接口请求成功 开始保存数据到本 --> ${dbBean.name}.${dbBean.resourceId},文件大小 = $length --> destination = $destination")


        // 下面从返回的输入流中读取字节数据并保存为本地文件
        disposeOutputStream(response, destination, length, dbBean, progressCallback = {
            // 下载进度回调
            SubtitleDownloadManager.notifyDownloadProgress(it, dbBean)
        }, completeCallback = {
            // 下载成功之后保存数据库
            dbBean.path = destination
            //下载完成解析文件格式
            SubtitleUtils.parseFileCharsetName(dbBean)
            dbBean.status = SubtitleStatus.STATUS_COMPLETED
            SubtitleDownloadDatabase.getInstance(Utils.getApp()).subtitleDownloadDao()
                .update(dbBean)
            Logger.logD("${getClassTag()} --> disposeOnResponse() --> 文件保存在 = $destination -- resourceId = ${dbBean.resourceId} --> getSubtitleInfo = ${dbBean.getSubtitleInfo()}")
            // 下载完成
            SubtitleDownloadManager.notifyDownloadComplete(dbBean)
        })
    }

}