package com.transsion.subtitle_download.task

import android.text.TextUtils
import com.blankj.utilcode.util.Utils
import com.transsion.base.report.athena.Report
import com.transsion.subtitle_download.db.SubtitleDownloadDatabase
import com.transsion.subtitle_download.db.SubtitleDownloadTable
import com.transsion.subtitle_download.utils.Logger
import com.transsion.subtitle_download.utils.SubtitleUtils

/**
 * @author: zhangxinbing
 * @date : 2024/5/17 10:13
 * @description: 字幕下载埋点上报
 */
internal object SubtitleDownloadTaskReport {

    /**
     * 字幕下载
     */
    private const val SUBTITLE_DOWNLOAD = "subtitle_download"

    private fun getClassTag(): String = javaClass.simpleName

    private fun report(action: String, subBean: SubtitleDownloadTable) {
        val map = mutableMapOf<String, String>()
        map["resource_id"] = subBean.resourceId
        map["taskId"] = subBean.taskId ?: ""
        map["subject_id"] = subBean.subjectId ?: ""
        if (subBean.ep > 0) {
            map["ep"] = subBean.ep.toString()
        }
        if (subBean.se > 0) {
            map["se"] = subBean.se.toString()
        }
        map["lan"] = subBean.lan ?: ""
        map["lan_name"] = subBean.lanName ?: ""
        map["type"] = subBean.type.toString()
        map["status"] = subBean.status.toString()
        map["action"] = action
        Report.reportEvent("st_download_v2", SUBTITLE_DOWNLOAD, map)
    }


    // =============================================================================================


    /**
     * 用户创建下载字幕任务
     * 1. 创建时间戳
     * 2. 任务ID
     * 3. 字幕类型
     */
    fun reportDownloadTrigger(stDownloadTable: SubtitleDownloadTable) {
        if (TextUtils.isEmpty(stDownloadTable.taskId)) {
            val taskId = SubtitleUtils.getTaskId()
            stDownloadTable.taskId = taskId
            SubtitleDownloadDatabase.getInstance(Utils.getApp()).subtitleDownloadDao()
                .update(stDownloadTable)
            Logger.logW("${getClassTag()} --> reportDownloadTrigger() --> 用户创建了字幕下载任务 --> taskId = $taskId")

            // 上报代码
            report("trigger", stDownloadTable)
        }
    }

    /**
     * 字幕下载成功
     */
    fun reportDownloadSuccess(stDownloadTable: SubtitleDownloadTable) {
        Logger.logW("${getClassTag()} --> reportDownloadSuccess() --> 字幕任务下载成功 --> taskId = ${stDownloadTable.taskId} ")
        //上报代码
        report("success", stDownloadTable)
    }


    /**
     * 用户请求内置字幕列表接口
     */
    fun reportGetSubtitleList() {

    }

    /**
     * 内置字幕列表请求成功
     * 1. 是否有数据
     */
    fun reportGetListSuccess() {

    }

}