package com.transsion.subtitle_download.utils

import android.util.Log
import java.io.FileInputStream
import java.io.FileOutputStream
import java.util.zip.GZIPInputStream

/**
 * @author: zhangxinbing
 * @date : 2024/5/16 14:49
 * @description: 字幕解压工具
 */
internal object GzipUti {

    private const val BUFF_SIZE = 1024

    /**
     * Ungzip
     *
     * @param zipFilePath 压缩包文件全路径
     * @param destFilePath 解压缩的文件全路径
     * @return
     */
    fun unGzip(zipFilePath: String, destFilePath: String): Boolean {
        val buffer = ByteArray(BUFF_SIZE)
        var len: Int
        var fos: FileOutputStream? = null
        var fis: FileInputStream? = null
        var ungzip: GZIPInputStream? = null
        var result: Boolean
        try {
            fos = FileOutputStream(destFilePath)
            fis = FileInputStream(zipFilePath)
            ungzip = GZIPInputStream(fis)
            while (ungzip.read(buffer).also { len = it } != -1) {
                fos.write(buffer, 0, len)
            }
            result = true
        } catch (e: Throwable) {
            result = false
            Logger.logE("GzipUti --> unGzip() --> ${Log.getStackTraceString(e)}")
        } finally {
            try {
                ungzip?.close()
                fos?.close()
                fis?.close()
            } catch (e: Throwable) {
                e.printStackTrace()
            }
        }
        return result
    }
}