/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.subtitle_download.task;

import android.app.Application;
import android.content.Context;
import com.blankj.utilcode.util.Utils;
import com.transsion.subtitle_download.SubtitleDownloadManager;
import com.transsion.subtitle_download.db.SubtitleDownloadDatabase;
import com.transsion.subtitle_download.db.SubtitleDownloadTable;
import com.transsion.subtitle_download.task.BaseSubtitleDownloadTask;
import com.transsion.subtitle_download.utils.Logger;
import com.transsion.subtitle_download.utils.SubtitleUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016JY\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00050\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/transsion/subtitle_download/task/SearchOenSubtitleNewApiDownloadTask;", "Lcom/transsion/subtitle_download/task/BaseSubtitleDownloadTask;", "<init>", "()V", "disposeOnResponse", "", "response", "Lokhttp3/Response;", "dbBean", "Lcom/transsion/subtitle_download/db/SubtitleDownloadTable;", "disposeOutputStream", "", "destination", "", "length", "", "progressCallback", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "progress", "completeCallback", "Lkotlin/Function0;", "getFileNameFromResponse", "SubtitleDownload_release"})
@SourceDebugExtension(value={"SMAP\nSearchOenSubtitleNewApiDownloadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchOenSubtitleNewApiDownloadTask.kt\ncom/transsion/subtitle_download/task/SearchOenSubtitleNewApiDownloadTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class SearchOenSubtitleNewApiDownloadTask
extends BaseSubtitleDownloadTask {
    @Override
    public void disposeOnResponse(@NotNull Response response, @NotNull SubtitleDownloadTable dbBean) {
        String string;
        long length;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)dbBean, (String)"dbBean");
        ResponseBody responseBody = response.body();
        long l = length = responseBody != null ? responseBody.contentLength() : 0L;
        if (response.body() == null) {
            Logger.INSTANCE.logE(this.getClassTag() + " --> disposeOnResponse() --> null == response.body --> headers = " + response.headers());
        }
        String fileType = String.valueOf((string = dbBean.getUrl()) != null && (string = StringsKt.substringBefore$default((String)string, (String)"?", null, (int)2, null)) != null ? StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null) : null);
        Object object = this.getFileNameFromResponse(response);
        if (object == null) {
            object = dbBean.getName() + "." + fileType;
        }
        String filename = object;
        String filePath = dbBean.getEp() > 0 ? BaseSubtitleDownloadTask.Companion.getSUBTITLE_DOWNLOAD_FILE_PATH() + File.separatorChar + dbBean.getSubjectFileName() + "_S" + dbBean.getSe() + "_E" + dbBean.getEp() : BaseSubtitleDownloadTask.Companion.getSUBTITLE_DOWNLOAD_FILE_PATH() + File.separatorChar + dbBean.getSubjectFileName();
        SubtitleUtils.INSTANCE.createDirectoryIfNotExists(filePath);
        String destination = filePath + File.separatorChar + filename;
        Logger.INSTANCE.logD(this.getClassTag() + " --> disposeOnResponse() --> \u63a5\u53e3\u8bf7\u6c42\u6210\u529f \u5f00\u59cb\u4fdd\u5b58\u6570\u636e\u5230\u672c --> " + dbBean.getName() + "." + dbBean.getResourceId() + ",\u6587\u4ef6\u5927\u5c0f = " + length + " --> destination = " + destination);
        this.disposeOutputStream(response, destination, length, dbBean, (Function1<? super Integer, Unit>)((Function1)arg_0 -> SearchOenSubtitleNewApiDownloadTask.disposeOnResponse$lambda$0(dbBean, arg_0)), (Function0<Unit>)((Function0)() -> SearchOenSubtitleNewApiDownloadTask.disposeOnResponse$lambda$1(dbBean, destination, this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disposeOutputStream(@NotNull Response response, @NotNull String destination, long length, @NotNull SubtitleDownloadTable dbBean, @NotNull Function1<? super Integer, Unit> progressCallback, @NotNull Function0<Unit> completeCallback) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)dbBean, (String)"dbBean");
        Intrinsics.checkNotNullParameter(progressCallback, (String)"progressCallback");
        Intrinsics.checkNotNullParameter(completeCallback, (String)"completeCallback");
        SubtitleUtils.INSTANCE.createDirectoryIfNotExists(BaseSubtitleDownloadTask.Companion.getSUBTITLE_DOWNLOAD_FILE_PATH());
        SubtitleUtils.INSTANCE.createDirectoryIfNotExists(BaseSubtitleDownloadTask.Companion.getSUBTITLE_DOWNLOAD_ZIP_FILE_PATH());
        try {
            boolean bl2;
            Object object = response.body();
            if (object != null && (object = object.byteStream()) != null) {
                Closeable closeable = (Closeable)object;
                Throwable throwable = null;
                try {
                    boolean bl3;
                    InputStream inputStream = (InputStream)closeable;
                    boolean bl4 = false;
                    Closeable closeable2 = new FileOutputStream(destination);
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream fos = (FileOutputStream)closeable2;
                        boolean bl5 = false;
                        byte[] buffer = new byte[8192];
                        int bytesRead = 0;
                        while (true) {
                            int n;
                            int it = n = inputStream.read(buffer);
                            boolean bl6 = false;
                            bytesRead = it;
                            if (n == -1) break;
                            fos.write(buffer, 0, bytesRead);
                        }
                        completeCallback.invoke();
                        bl3 = true;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    boolean bl7 = bl3;
                    bl2 = bl7;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            bl2 = false;
            bl = bl2;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    private final String getFileNameFromResponse(Response response) {
        Pattern pattern;
        Matcher matcher;
        String contentDisposition = Response.header$default((Response)response, (String)"Content-Disposition", null, (int)2, null);
        if (contentDisposition != null && (matcher = (pattern = Pattern.compile("filename=\"?([^\";]*)\"?")).matcher(contentDisposition)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static final Unit disposeOnResponse$lambda$0(SubtitleDownloadTable $dbBean, int it) {
        SubtitleDownloadManager.INSTANCE.notifyDownloadProgress$SubtitleDownload_release(it, $dbBean);
        return Unit.INSTANCE;
    }

    private static final Unit disposeOnResponse$lambda$1(SubtitleDownloadTable $dbBean, String $destination, SearchOenSubtitleNewApiDownloadTask this$0) {
        $dbBean.setPath($destination);
        SubtitleUtils.INSTANCE.parseFileCharsetName($dbBean);
        $dbBean.setStatus(5);
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
        SubtitleDownloadDatabase.Companion.getInstance$SubtitleDownload_release((Context)application).subtitleDownloadDao().update($dbBean);
        Logger.INSTANCE.logD(this$0.getClassTag() + " --> disposeOnResponse() --> \u6587\u4ef6\u4fdd\u5b58\u5728 = " + $destination + " -- resourceId = " + $dbBean.getResourceId() + " --> getSubtitleInfo = " + $dbBean.getSubtitleInfo());
        SubtitleDownloadManager.INSTANCE.notifyDownloadComplete$SubtitleDownload_release($dbBean);
        return Unit.INSTANCE;
    }
}

