/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.subtitle_download.task;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import com.blankj.utilcode.util.Utils;
import com.transsion.subtitle_download.SubtitleDownloadManager;
import com.transsion.subtitle_download.db.SubtitleDownloadDatabase;
import com.transsion.subtitle_download.db.SubtitleDownloadTable;
import com.transsion.subtitle_download.task.BaseSubtitleDownloadTask;
import com.transsion.subtitle_download.utils.GzipUti;
import com.transsion.subtitle_download.utils.Logger;
import com.transsion.subtitle_download.utils.SubtitleUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/transsion/subtitle_download/task/SearchOpenSubtitleDownloadTask;", "Lcom/transsion/subtitle_download/task/BaseSubtitleDownloadTask;", "<init>", "()V", "disposeOnResponse", "", "response", "Lokhttp3/Response;", "dbBean", "Lcom/transsion/subtitle_download/db/SubtitleDownloadTable;", "unGzZip", "", "parseFileCharsetName", "SubtitleDownload_release"})
public final class SearchOpenSubtitleDownloadTask
extends BaseSubtitleDownloadTask {
    @Override
    public void disposeOnResponse(@NotNull Response response, @NotNull SubtitleDownloadTable dbBean) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)dbBean, (String)"dbBean");
        int n = response.code();
        boolean bl = 200 <= n ? n < 300 : false;
        if (bl) {
            String string;
            List list;
            String contentDis;
            String string2 = contentDis = response.headers().get("Content-Disposition");
            if (string2 != null) {
                String[] stringArray = new String[]{"filename="};
                list = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            } else {
                list = null;
            }
            List list2 = list;
            Logger.INSTANCE.logD(this.getClassTag() + " --> disposeOnResponse() --> \u8bf7\u6c42\u6210\u529f --> response.code = " + response.code() + " -- list = " + list2);
            List list3 = list2;
            boolean bl2 = list3 != null ? !((Collection)list3).isEmpty() : false;
            if (bl2 && list2.size() > 1) {
                String decodeFilename = Uri.decode((String)((String)list2.get(1))).toString();
                Regex regex = new Regex("[\\\\/:*?\"<>|]");
                CharSequence charSequence = decodeFilename;
                String string3 = "";
                String filename = regex.replace(charSequence, string3);
                string = BaseSubtitleDownloadTask.Companion.getSUBTITLE_DOWNLOAD_ZIP_FILE_PATH() + File.separatorChar + filename;
            } else {
                string = BaseSubtitleDownloadTask.Companion.getSUBTITLE_DOWNLOAD_ZIP_FILE_PATH() + File.separatorChar + Uri.decode((String)dbBean.getName()).hashCode();
            }
            String zipPath = string;
            ResponseBody responseBody = response.body();
            long length = responseBody != null ? responseBody.contentLength() : 0L;
            boolean disposeOutputStream = this.disposeOutputStream(response, zipPath, length, dbBean, (Function1<? super Integer, Unit>)((Function1)arg_0 -> SearchOpenSubtitleDownloadTask.disposeOnResponse$lambda$0(dbBean, arg_0)), (Function0<Unit>)((Function0)() -> SearchOpenSubtitleDownloadTask.disposeOnResponse$lambda$1(dbBean, zipPath, this)));
            if (!disposeOutputStream) {
                return;
            }
            boolean unGzZip = this.unGzZip(dbBean);
            if (!unGzZip) {
                return;
            }
            boolean parseFileCharsetName = this.parseFileCharsetName(dbBean);
            if (!parseFileCharsetName) {
                return;
            }
            Logger.INSTANCE.logE("--------------------------------------------------------------------");
        } else {
            this.disposeOnFailure(dbBean, new RuntimeException(this.getClassTag() + " --> disposeOnResponse() --> \u641c\u7d22\u5b57\u5e55\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25 --> response.code = " + response.code()));
        }
    }

    private final boolean unGzZip(SubtitleDownloadTable dbBean) {
        SubtitleDownloadManager.INSTANCE.notifyUnGzZip$SubtitleDownload_release(dbBean);
        boolean isUnZipSuccess = false;
        String it = dbBean.getZipPath();
        boolean bl = false;
        Logger.INSTANCE.logD(this.getClassTag() + " --> unGzZip() --> \u5b57\u5e55\u538b\u7f29\u5305\u4e0b\u8f7d\u6210\u529f --> \u5f00\u59cb\u89e3\u538b\u7f29 .... zipPath = " + it);
        String parentPath = dbBean.getEp() > 0 ? BaseSubtitleDownloadTask.Companion.getSUBTITLE_DOWNLOAD_FILE_PATH() + File.separatorChar + dbBean.getSubjectFileName() + "_S" + dbBean.getSe() + "_E" + dbBean.getEp() : BaseSubtitleDownloadTask.Companion.getSUBTITLE_DOWNLOAD_FILE_PATH() + File.separatorChar + dbBean.getSubjectFileName();
        SubtitleUtils.INSTANCE.createDirectoryIfNotExists(parentPath);
        String newPath = parentPath + File.separatorChar + dbBean.getName();
        boolean result = GzipUti.INSTANCE.unGzip(dbBean.getZipPath(), newPath);
        if (result) {
            Logger.INSTANCE.logD(this.getClassTag() + " --> unGzZip() --> \u5b57\u5e55\u538b\u7f29\u5305\u4e0b\u8f7d\u6210\u529f --> \u5f00\u59cb\u89e3\u538b\u7f29 --> \u89e3\u538b\u7f29\u6210\u529f");
            dbBean.setPath(newPath);
            isUnZipSuccess = true;
        } else {
            this.disposeOnFailure(dbBean, new RuntimeException(this.getClassTag() + " --> unGzZip() --> \u5b57\u5e55\u538b\u7f29\u6587\u4ef6\u89e3\u538b\u5931\u8d25"));
            isUnZipSuccess = false;
        }
        SearchOpenSubtitleDownloadTask searchOpenSubtitleDownloadTask = this;
        try {
            SearchOpenSubtitleDownloadTask $this$unGzZip_u24lambda_u243_u24lambda_u242 = searchOpenSubtitleDownloadTask;
            boolean bl2 = false;
            File file = new File(it);
            file.delete();
            Logger.INSTANCE.logD($this$unGzZip_u24lambda_u243_u24lambda_u242.getClassTag() + " --> unGzZip() --> result = " + result + " -- \u65e0\u8bba\u6210\u529f\u5931\u8d25\uff0c\u90fd\u5220\u9664\u538b\u7f29\u5305 -- \u8fd9\u91cc\u4fee\u6539\u6210\u5220\u9664\u538b\u7f29\u7f13\u5b58\u6587\u4ef6\u5939\u91cc\u9762\u7684\u6240\u6709\u6587\u4ef6");
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return isUnZipSuccess;
    }

    private final boolean parseFileCharsetName(SubtitleDownloadTable dbBean) {
        boolean bl;
        boolean parseState = SubtitleUtils.INSTANCE.parseFileCharsetName(dbBean);
        if (parseState) {
            Logger.INSTANCE.logD(this.getClassTag() + " --> parseFileCharsetName() --> \u5b57\u5e55\u538b\u7f29\u5305\u4e0b\u8f7d\u6210\u529f --> \u5f00\u59cb\u89e3\u6790\u5b57\u5e55\u6587\u4ef6\u7684\u7f16\u7801\u683c\u5f0f --> \u6210\u529f --> \u4fdd\u5b58\u72b6\u6001\u5230\u6570\u636e\u5e93");
            dbBean.setStatus(5);
            Application application = Utils.getApp();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
            SubtitleDownloadDatabase.Companion.getInstance$SubtitleDownload_release((Context)application).subtitleDownloadDao().update(dbBean);
            SubtitleDownloadManager.INSTANCE.notifyDownloadComplete$SubtitleDownload_release(dbBean);
            bl = true;
        } else {
            try {
                boolean bl2 = false;
                String string = dbBean.getPath();
                if (string == null) {
                    string = "";
                }
                File file = new File(string);
                Object object = Result.constructor-impl((Object)file.delete());
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            this.disposeOnFailure(dbBean, new RuntimeException(this.getClassTag() + " --> parseFileCharsetName() --> \u89e3\u6790\u5b57\u5e55\u6587\u4ef6\u7684\u7f16\u7801\u683c\u5f0f\u5931\u8d25 --> \u5220\u9664\u5b57\u5e55\u6587\u4ef6"));
            bl = false;
        }
        return bl;
    }

    private static final Unit disposeOnResponse$lambda$0(SubtitleDownloadTable $dbBean, int it) {
        SubtitleDownloadManager.INSTANCE.notifyDownloadProgress$SubtitleDownload_release(it, $dbBean);
        return Unit.INSTANCE;
    }

    private static final Unit disposeOnResponse$lambda$1(SubtitleDownloadTable $dbBean, String $zipPath, SearchOpenSubtitleDownloadTask this$0) {
        $dbBean.setZipPath($zipPath);
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
        SubtitleDownloadDatabase.Companion.getInstance$SubtitleDownload_release((Context)application).subtitleDownloadDao().update($dbBean);
        Logger.INSTANCE.logD(this$0.getClassTag() + " --> disposeOnResponse() --> \u538b\u7f29\u6587\u4ef6\u4fdd\u5b58\u5728 = " + $zipPath + " -- getSubtitleInfo = " + $dbBean.getSubtitleInfo());
        return Unit.INSTANCE;
    }
}

