/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.subtitle_download.task;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.WorkerThread;
import com.blankj.utilcode.util.Utils;
import com.transsion.subtitle_download.SubtitleDownloadManager;
import com.transsion.subtitle_download.db.SubtitleDownloadDatabase;
import com.transsion.subtitle_download.db.SubtitleDownloadTable;
import com.transsion.subtitle_download.task.InStationSubtitleDownloadTask;
import com.transsion.subtitle_download.task.SearchOenSubtitleNewApiDownloadTask;
import com.transsion.subtitle_download.task.SearchOpenSubtitleDownloadTask;
import com.transsion.subtitle_download.task.SubtitleDownloadTaskReport;
import com.transsion.subtitle_download.utils.Logger;
import com.transsion.subtitle_download.utils.SubtitleUtils;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u000e\u001a\u00020\nH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/transsion/subtitle_download/task/SubtitleDownloadTaskManager;", "", "<init>", "()V", "getClassTag", "", "taskList", "Ljava/util/concurrent/LinkedBlockingDeque;", "Lcom/transsion/subtitle_download/db/SubtitleDownloadTable;", "isDownloading", "", "addTaskAndExecute", "", "dbBean", "isPrivilege", "downloadFinal", "downloadNext", "SubtitleDownload_release"})
@SourceDebugExtension(value={"SMAP\nSubtitleDownloadTaskManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubtitleDownloadTaskManager.kt\ncom/transsion/subtitle_download/task/SubtitleDownloadTaskManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1869#2,2:150\n*S KotlinDebug\n*F\n+ 1 SubtitleDownloadTaskManager.kt\ncom/transsion/subtitle_download/task/SubtitleDownloadTaskManager\n*L\n63#1:150,2\n*E\n"})
public final class SubtitleDownloadTaskManager {
    @NotNull
    public static final SubtitleDownloadTaskManager INSTANCE = new SubtitleDownloadTaskManager();
    @NotNull
    private static final LinkedBlockingDeque<SubtitleDownloadTable> taskList = new LinkedBlockingDeque();
    private static volatile boolean isDownloading;

    private SubtitleDownloadTaskManager() {
    }

    private final String getClassTag() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    @WorkerThread
    public final void addTaskAndExecute(@NotNull SubtitleDownloadTable dbBean, boolean isPrivilege) {
        Intrinsics.checkNotNullParameter((Object)dbBean, (String)"dbBean");
        if (SubtitleUtils.INSTANCE.isFileExist(dbBean.getPath())) {
            Logger.INSTANCE.logW(this.getClassTag() + " --> addTaskAndExecute() --> \u5f00\u59cb\u4e0b\u8f7d\u5b57\u5e55 --> \u5982\u679c\u5b57\u5e55\u8d44\u6e90\u5df2\u7ecf\u4e0b\u8f7d\u5b8c\u6210\u4e86\uff0c\u90a3\u5c31\u76f4\u63a5\u8df3\u8fc7 --> next() -- getSubtitleInfo = " + dbBean.getSubtitleInfo());
            dbBean.setStatus(5);
            Application application = Utils.getApp();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp(...)");
            SubtitleDownloadDatabase.Companion.getInstance$SubtitleDownload_release((Context)application).subtitleDownloadDao().update(dbBean);
            SubtitleDownloadManager.INSTANCE.notifyDownloadComplete$SubtitleDownload_release(dbBean);
            return;
        }
        boolean hasTask = false;
        Iterable $this$forEach$iv = taskList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SubtitleDownloadTable it = (SubtitleDownloadTable)element$iv;
            boolean bl = false;
            if (!TextUtils.equals((CharSequence)it.getId(), (CharSequence)dbBean.getId())) continue;
            hasTask = true;
        }
        if (hasTask) {
            return;
        }
        SubtitleDownloadTaskReport.INSTANCE.reportDownloadTrigger(dbBean);
        if (isPrivilege) {
            taskList.addFirst(dbBean);
        } else {
            taskList.add(dbBean);
        }
        Logger.INSTANCE.logD(this.getClassTag() + " --> addTaskAndExecute() --> \u5269\u4f59\u4efb\u52a1\u6570\u91cf -- taskList.size = " + taskList.size() + " --> isDownloading = " + isDownloading + " --> dbBean.failCount = " + dbBean.getFailCount());
        this.downloadNext();
    }

    public static /* synthetic */ void addTaskAndExecute$default(SubtitleDownloadTaskManager subtitleDownloadTaskManager, SubtitleDownloadTable subtitleDownloadTable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        subtitleDownloadTaskManager.addTaskAndExecute(subtitleDownloadTable, bl);
    }

    private final void downloadFinal() {
        isDownloading = false;
        this.downloadNext();
    }

    private final void downloadNext() {
        Object $this$downloadNext_u24lambda_u245;
        if (isDownloading || taskList.isEmpty()) {
            if (taskList.isEmpty()) {
                Logger.INSTANCE.logW(this.getClassTag() + " --> downloadNext() --> taskList = " + taskList.size() + " -- \u5f53\u524d\u6ca1\u6709\u53ef\u6267\u884c\u4efb\u52a1\u4e86");
            }
            return;
        }
        isDownloading = true;
        Object object = this;
        try {
            Unit unit;
            $this$downloadNext_u24lambda_u245 = object;
            boolean bl = false;
            SubtitleDownloadTable subtitleDownloadTable = taskList.removeFirst();
            if (subtitleDownloadTable != null) {
                SubtitleDownloadTable it = subtitleDownloadTable;
                boolean bl2 = false;
                switch (it.getType()) {
                    case 4: {
                        new SearchOpenSubtitleDownloadTask().download(it, (Function0<Unit>)((Function0)() -> SubtitleDownloadTaskManager.downloadNext$lambda$5$lambda$4$lambda$1((SubtitleDownloadTaskManager)$this$downloadNext_u24lambda_u245)));
                        break;
                    }
                    case 5: {
                        new SearchOenSubtitleNewApiDownloadTask().download(it, (Function0<Unit>)((Function0)() -> SubtitleDownloadTaskManager.downloadNext$lambda$5$lambda$4$lambda$2((SubtitleDownloadTaskManager)$this$downloadNext_u24lambda_u245)));
                        break;
                    }
                    default: {
                        new InStationSubtitleDownloadTask().download(it, (Function0<Unit>)((Function0)() -> SubtitleDownloadTaskManager.downloadNext$lambda$5$lambda$4$lambda$3((SubtitleDownloadTaskManager)$this$downloadNext_u24lambda_u245)));
                    }
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            $this$downloadNext_u24lambda_u245 = Result.constructor-impl(unit);
        }
        catch (Throwable bl) {
            $this$downloadNext_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$downloadNext_u24lambda_u245;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            Logger.INSTANCE.logE(INSTANCE.getClassTag() + " --> downloadNext() --> \u6267\u884c\u4e0b\u8f7d\u4efb\u52a1\u53d1\u751f\u5f02\u5e38 -- it = " + Log.getStackTraceString((Throwable)it));
            INSTANCE.downloadFinal();
        }
    }

    private static final Unit downloadNext$lambda$5$lambda$4$lambda$1(SubtitleDownloadTaskManager $this_runCatching) {
        $this_runCatching.downloadFinal();
        return Unit.INSTANCE;
    }

    private static final Unit downloadNext$lambda$5$lambda$4$lambda$2(SubtitleDownloadTaskManager $this_runCatching) {
        $this_runCatching.downloadFinal();
        return Unit.INSTANCE;
    }

    private static final Unit downloadNext$lambda$5$lambda$4$lambda$3(SubtitleDownloadTaskManager $this_runCatching) {
        $this_runCatching.downloadFinal();
        return Unit.INSTANCE;
    }
}

