package com.transsion.sunflower

import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.PendingIntent
import android.content.Context
import android.media.AudioAttributes
import android.net.Uri
import android.os.Build.VERSION
import androidx.annotation.DrawableRes
import androidx.core.app.NotificationCompat

class FSNotificationHelper(
    context: Context,
    private val channelId: String = "default",
    private val channelName: String = "Default_Channel"
) {
    private var channel: NotificationChannel? = null

    init {
        if (VERSION.SDK_INT >= 26) {
            this.channel = NotificationChannel(this.channelId, this.channelName, NotificationManager.IMPORTANCE_HIGH)
            channel?.setSound(null as Uri?, null as AudioAttributes?)
            channel?.enableVibration(false)
            channel?.lockscreenVisibility = NotificationCompat.VISIBILITY_SECRET
            val mManager = context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            mManager.createNotificationChannel(channel!!)
        }
    }

    fun postFullScreenNotification(
        context: Context,
        title: String?,
        info: String?,
        @DrawableRes icon: Int,
        intent: PendingIntent?,
        notificationId: Int
    ) {
        val builder =
            NotificationCompat.Builder(context, this.channelId).setSmallIcon(icon)
                .setContentInfo(info).setContentTitle(title).setFullScreenIntent(intent, true)
                .setAutoCancel(true)
        val notification = builder.build()

        try {
            val mManager =
                context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            mManager.cancel(notificationId)
            mManager.notify(notificationId, notification)
        } catch (e: Throwable) {
            e.printStackTrace()
        }
    }

    fun postFullScreenNotification(
        context: Context,
        builder: NotificationCompat.Builder,
        fullScreenIntent: PendingIntent?,
        notificationId: Int
    ) {
        builder.setFullScreenIntent(fullScreenIntent, true)

        try {
            val mManager =
                context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            mManager.cancel(notificationId)
            mManager.notify(notificationId, builder.build())
        } catch (e: Throwable) {
            e.printStackTrace()
        }
    }

    companion object {
        fun cancelNotification(context: Context, notificationId: Int) {
            val notifyMgr =
                context.getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
            try {
                notifyMgr.cancel(notificationId)
            } catch (e: Throwable) {
                e.printStackTrace()
            }
        }
    }
}