package com.tn.lib.thread

import java.util.concurrent.*
import java.util.concurrent.atomic.AtomicInteger

/**
 * Transsion MI
 * Created By Liupeng
 * On: 2022/9/8 00:10
 *
 *
 * Desc
 */
class ThreadPool private constructor() {

    companion object {

        @JvmStatic
        val INSTANCE: ThreadPool by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            ThreadPool()
        }

        /**
         * 这里实际上是没有被系统"禁用"的cpu核数
         */
        private val CPU_COUNT = Runtime.getRuntime().availableProcessors()

        /**
         * 如果针对低端机优化可执行悲观策略
         */
        private val CORE_POOL_SIZE = (CPU_COUNT - 1).coerceAtMost(4)
        private val MAXIMUM_POOL_SIZE = (CPU_COUNT * 2 + 1).coerceAtMost(8)
        private const val KEEP_ALIVE_SECONDS = 30
        private val sPoolWorkQueue: BlockingQueue<Runnable> = LinkedBlockingQueue(64)
        private val sThreadFactory: ThreadFactory = object : ThreadFactory {
            private val mCount = AtomicInteger(1)
            override fun newThread(runnable: Runnable): Thread {
                return BackgroundThread(runnable, "or_threadpool_" + mCount.getAndIncrement())
            }
        }
        private var THREAD_POOL_EXECUTOR: ThreadPoolExecutor? = null


    }

    init {
        val threadPoolExecutor = ThreadPoolExecutor(
            CORE_POOL_SIZE,
            MAXIMUM_POOL_SIZE,
            KEEP_ALIVE_SECONDS.toLong(),
            TimeUnit.SECONDS,
            sPoolWorkQueue,
            sThreadFactory,  //这里拒绝策略选择:返回调用者线程去执行
            ThreadPoolExecutor.CallerRunsPolicy()
        )
        threadPoolExecutor.allowCoreThreadTimeOut(true)
        THREAD_POOL_EXECUTOR = threadPoolExecutor
    }

    private class BackgroundThread(runnable: Runnable?, name: String?) : Thread(runnable, name) {
        init {
            this@BackgroundThread.priority = NORM_PRIORITY
        }
    }

    fun execute(task: Runnable?) {
        THREAD_POOL_EXECUTOR?.execute(task)
    }

    fun submit(task: Runnable?): Future<*>? {
        return THREAD_POOL_EXECUTOR?.submit(task)
    }

    fun onDestroy() {
        THREAD_POOL_EXECUTOR!!.shutdownNow()
    }
}