package com.tn.lib.thread.config

import android.os.Handler
import android.os.Looper
import java.util.concurrent.Executor

/**
 * 线程切换 任务完成切换Android UI线程
 * @author: huangyeling
 * @date: 2021/7/29
 */
class HandlerDeliver: Executor{

    private val mainHander = Handler(Looper.getMainLooper())

    override fun execute(command: Runnable?) {
        if(Looper.myLooper() == Looper.getMainLooper()){
            command?.run()
            return
        }
        mainHander?.post { command?.run() }
    }

    companion object {
        val instance = HandlerDeliver()
    }
}