package com.tn.lib.thread.config

import com.tn.lib.thread.callback.RunnableCallback

/**
 * @author: huangyeling
 * @date: 2021/7/29
 */
class ThreadTools {

    companion object {

        /**
         * 重置Thread
         */
        fun restThread(thread: Thread, name: String, runnableCallback: RunnableCallback) {
            thread?.setUncaughtExceptionHandler { t, e ->
                runnableCallback.onError(name, e)
            }
            thread.name = name
        }

        /**
         * 休眠Thread
         */
        fun sleepThread(time: Long) {
            if (time <= 0) {
                return
            }
            try {
                Thread.sleep(time)
            } catch (e: InterruptedException) {
                throw RuntimeException("Thread has been interrupted", e)
            }
        }
    }


}